/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSPropertyEnums;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnums
extends AbstractCSSPropertyEnums {
    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ICSSPropertyCustomizer)null, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        this(eProp, (ECSSVendorPrefix)null, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, eVendorPrefix, aCustomizer, nMinNumbers, nMaxNumbers, aEnumValues);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.getMinimumArgumentCount() || aParts.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String sPart : aParts) {
            if (super.isValidValue(sPart.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnums(eProp, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyEnums(this.getProp(), eVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }
}

