/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyNumber
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;

    public CSSPropertyNumber(@Nonnull ECSSProperty eProp, boolean bWithPercentage) {
        this(eProp, (ICSSPropertyCustomizer)null, bWithPercentage);
    }

    public CSSPropertyNumber(@Nonnull ECSSProperty eProp, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage) {
        this(eProp, null, aCustomizer, bWithPercentage);
    }

    public CSSPropertyNumber(@Nonnull ECSSProperty eProp, @Nullable ECSSVendorPrefix eVendorPrefix, @Nullable ICSSPropertyCustomizer aCustomizer, boolean bWithPercentage) {
        super(eProp, eVendorPrefix, aCustomizer);
        this.m_bWithPercentage = bWithPercentage;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String sValue) {
        return super.isValidValue(sValue) || CSSNumberHelper.isValueWithUnit(sValue, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyNumber getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyNumber(eProp, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyNumber getClone(@Nullable ECSSVendorPrefix eVendorPrefix) {
        return new CSSPropertyNumber(this.getProp(), eVendorPrefix, this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSSPropertyNumber rhs = (CSSPropertyNumber)o;
        return this.m_bWithPercentage == rhs.m_bWithPercentage;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).getToString();
    }
}

