/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSUnit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSimpleValueWithUnit
implements Serializable {
    private BigDecimal m_aValue;
    private ECSSUnit m_eUnit;

    public CSSSimpleValueWithUnit(@Nonnull BigDecimal aValue, @Nonnull ECSSUnit eUnit) {
        this.setValue(aValue);
        this.setUnit(eUnit);
    }

    public CSSSimpleValueWithUnit(double dValue, @Nonnull ECSSUnit eUnit) {
        this(BigDecimal.valueOf(dValue), eUnit);
    }

    @Nonnull
    public CSSSimpleValueWithUnit setValue(@Nonnull BigDecimal aValue) {
        this.m_aValue = (BigDecimal)ValueEnforcer.notNull((Object)aValue, (String)"Value");
        return this;
    }

    @Nonnull
    public CSSSimpleValueWithUnit setValue(double dValue) {
        return this.setValue(BigDecimal.valueOf(dValue));
    }

    @Nonnull
    public BigDecimal getAsBigDecimalValue() {
        return this.m_aValue;
    }

    public double getValue() {
        return this.m_aValue.doubleValue();
    }

    public int getAsIntValue() {
        return this.m_aValue.intValue();
    }

    public long getAsLongValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public CSSSimpleValueWithUnit setUnit(@Nonnull ECSSUnit eUnit) {
        this.m_eUnit = (ECSSUnit)ValueEnforcer.notNull((Object)eUnit, (String)"Unit");
        return this;
    }

    @Nonnull
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Nonnull
    @Nonempty
    public String getFormatted() {
        return this.m_eUnit.format(this.m_aValue);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit add(@Nonnull BigDecimal aDelta) {
        return new CSSSimpleValueWithUnit(this.m_aValue.add(aDelta), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit add(double dDelta) {
        return this.add(BigDecimal.valueOf(dDelta));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit substract(@Nonnull BigDecimal aDelta) {
        return new CSSSimpleValueWithUnit(this.m_aValue.subtract(aDelta), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit substract(double dDelta) {
        return this.substract(BigDecimal.valueOf(dDelta));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit multiply(@Nonnull BigDecimal aValue) {
        return new CSSSimpleValueWithUnit(this.m_aValue.multiply(aValue), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit multiply(double dValue) {
        return this.multiply(BigDecimal.valueOf(dValue));
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(@Nonnull BigDecimal aDivisor, @Nonnegative int nScale, @Nonnull RoundingMode eRoundingMode) {
        return new CSSSimpleValueWithUnit(this.m_aValue.divide(aDivisor, nScale, eRoundingMode), this.m_eUnit);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(@Nonnull BigDecimal aDivisor) {
        return this.divide(aDivisor, 16, RoundingMode.HALF_UP);
    }

    @Nonnull
    @CheckReturnValue
    public CSSSimpleValueWithUnit divide(double dDivisor) {
        return this.divide(BigDecimal.valueOf(dDivisor));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSimpleValueWithUnit rhs = (CSSSimpleValueWithUnit)o;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)rhs.m_aValue) && this.m_eUnit.equals(rhs.m_eUnit);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValue).append((Enum)this.m_eUnit).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("value", (Object)this.m_aValue).append("unit", (Enum)this.m_eUnit).getToString();
    }
}

