/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSSValue
implements ICSSValue {
    public static final boolean DEFAULT_CONSISTENCY_CHECKS_ENABLED = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSValue.class);
    private static boolean s_bConsistencyChecksEnabled = true;
    private ICSSProperty m_aProperty;
    private String m_sValue;
    private boolean m_bIsImportant;

    public static boolean areConsistencyChecksEnabled() {
        return s_bConsistencyChecksEnabled;
    }

    public static void setConsistencyChecksEnabled(boolean bEnabled) {
        s_bConsistencyChecksEnabled = bEnabled;
    }

    public CSSValue(@Nonnull ICSSProperty aProperty, @Nonnull String sValue, boolean bIsImportant) {
        this.setProperty(aProperty);
        this.setValue(sValue);
        this.setImportant(bIsImportant);
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aProperty.getProp();
    }

    @Nonnull
    @Nonempty
    public String getPropertyName() {
        return this.m_aProperty.getPropertyName();
    }

    @Nonnull
    public CSSValue setProperty(@Nonnull ICSSProperty aProperty) {
        this.m_aProperty = (ICSSProperty)ValueEnforcer.notNull((Object)aProperty, (String)"Property");
        return this;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public CSSValue setValue(@Nonnull String sValue) {
        ValueEnforcer.notNull((Object)sValue, (String)"Value");
        if (CSSValue.areConsistencyChecksEnabled()) {
            if (!this.m_aProperty.isValidValue(sValue)) {
                LOGGER.warn("CSS: the value '" + sValue + "' is not valid for property '" + this.m_aProperty.getPropertyName() + "'");
            }
            if (sValue.contains(" !important")) {
                LOGGER.warn("CSS: the value '" + sValue + "' should not contain the '" + " !important" + "' string! Use 'setImportant' method instead.");
            }
        }
        this.m_sValue = sValue.trim();
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSValue setImportant(boolean bIsImportant) {
        this.m_bIsImportant = bIsImportant;
        return this;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this.m_aProperty);
        return this.m_aProperty.getPropertyName() + ':' + this.m_sValue + (StringHelper.hasText((String)this.m_sValue) && this.m_bIsImportant ? " !important" : "") + ';';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSValue rhs = (CSSValue)o;
        return this.m_aProperty.getProp().equals(rhs.m_aProperty.getProp()) && this.m_sValue.equals(rhs.m_sValue) && this.m_bIsImportant == rhs.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_aProperty.getProp()).append((Object)this.m_sValue).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("value", (Object)this.m_sValue).append("important", this.m_bIsImportant).getToString();
    }
}

