/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSMultiValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSValueMultiValue
implements ICSSMultiValue {
    private final ICommonsList<CSSValue> m_aValues = new CommonsArrayList();

    public CSSValueMultiValue(@Nonnull ICSSProperty aProperty, @Nonnull @Nonempty String[] aValues, boolean bIsImportant) {
        ValueEnforcer.notNull((Object)aProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])aValues, (String)"Values");
        for (String sValue : aValues) {
            this.m_aValues.add((Object)new CSSValue(aProperty, sValue, bIsImportant));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSValue> getAllContainedValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return ((CSSValue)this.m_aValues.getFirst()).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return StringHelper.getImplodedMapped(this.m_aValues, x -> x.getAsCSSString(aSettings, nIndentLevel));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSValueMultiValue rhs = (CSSValueMultiValue)o;
        return this.m_aValues.equals(rhs.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).getToString();
    }
}

