/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasReader;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.streamprovider.StringInputStreamProvider;
import com.helger.commons.io.streamprovider.StringReaderProvider;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSSCharsetDetector;
import com.helger.css.parser.ParserCSSCharsetDetectorTokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSSReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSReader.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="s_aRWLock")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReader s_aInstance = new CSSReader();

    private CSSReader() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return (ICSSParseErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler aDefaultParseErrorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseErrorHandler = aDefaultParseErrorHandler;
            return s_aDefaultParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return (ICSSParseExceptionCallback)s_aRWLock.readLocked(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback aDefaultParseExceptionHandler) {
        ValueEnforcer.notNull((Object)aDefaultParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = aDefaultParseExceptionHandler;
            return s_aDefaultParseExceptionHandler;
        });
    }

    @Nonnull
    public static ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return (ICSSInterpretErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@Nonnull ICSSInterpretErrorHandler aDefaultErrorHandler) {
        ValueEnforcer.notNull((Object)aDefaultErrorHandler, (String)"DefaultErrorHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = aDefaultErrorHandler;
            return s_aDefaultInterpretErrorHandler;
        });
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream aCharStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nonnull ICSSParseExceptionCallback aCustomExceptionHandler, boolean bBrowserCompliantMode) {
        try {
            switch (eVersion) {
                case CSS21: 
                case CSS30: {
                    ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aCharStream);
                    aTokenHdl.setCustomErrorHandler(aCustomErrorHandler);
                    ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                    aParser.setCustomErrorHandler(aCustomErrorHandler);
                    aParser.setBrowserCompliantMode(bBrowserCompliantMode);
                    return aParser.styleSheet();
                }
            }
            throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
        }
        catch (ParseException ex) {
            aCustomExceptionHandler.onException(ex);
            return null;
        }
        catch (Throwable ex) {
            aCustomExceptionHandler.onException(new ParseException(ex.getMessage()));
            return null;
        }
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(aFile), aFallbackCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aRes, (String)"Resource");
        ValueEnforcer.notNull((Object)aFallbackCharset, (String)"FallbackCharset");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Reader aReader = aRes.getReader(aFallbackCharset);
        if (aReader == null) {
            LOGGER.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReader.isValidCSS(aReader, eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notNull((Object)aFallbackCharset, (String)"FallbackCharset");
        return CSSReader.isValidCSS(StreamHelper.createReader((InputStream)aIS, (Charset)aFallbackCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)sCSS, (String)"CSS");
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            CSSNode aNode = CSSReader._readStyleSheet(aCharStream, eVersion, CSSReader.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback(), false);
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStringStream(sCSS, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromStringStream(sCSS, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStringStream(sCSS, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStringStream(sCSS, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringStream(@Nonnull String sCSS, @Nonnull CSSReaderSettings aSettings) {
        return CSSReader.readFromStream((IHasInputStream)new StringInputStreamProvider(sCSS, aSettings.getFallbackCharset()), aSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStringReader(sCSS, new CSSReaderSettings().setCSSVersion(eVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromStringReader(sCSS, new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStringReader(sCSS, new CSSReaderSettings().setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStringReader(sCSS, new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStringReader(@Nonnull String sCSS, @Nonnull CSSReaderSettings aSettings) {
        return CSSReader.readFromReader((IHasReader)new StringReaderProvider(sCSS), aSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromFile(aFile, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromFile(aFile, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromFile(aFile, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromFile(aFile, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File aFile, @Nonnull CSSReaderSettings aSettings) {
        return CSSReader.readFromStream((IHasInputStream)new FileSystemResource(aFile), aSettings);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReader.readFromStream(aISP, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReader.readFromStream(aISP, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IHasInputStream aISP) {
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset aISAndBOM = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)aIS);
        Charset aBOMCharset = aISAndBOM.getCharset();
        Charset aStreamCharset = aBOMCharset;
        if (aStreamCharset == null) {
            aStreamCharset = StandardCharsets.ISO_8859_1;
        }
        InputStreamReader aReader = StreamHelper.createReader((InputStream)aISAndBOM.getInputStream(), (Charset)aStreamCharset);
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            ParserCSSCharsetDetectorTokenManager aTokenHdl = new ParserCSSCharsetDetectorTokenManager(aCharStream);
            ParserCSSCharsetDetector aParser = new ParserCSSCharsetDetector(aTokenHdl);
            String sCharsetName = aParser.styleSheetCharset().getText();
            if (sCharsetName == null) {
                Charset charset = aBOMCharset;
                return charset;
            }
            String sPlainCharsetName = CSSParseHelper.extractStringValue(sCharsetName);
            Charset aReadCharset = CharsetHelper.getCharsetFromName((String)sPlainCharsetName);
            if (aBOMCharset != null && !aBOMCharset.equals(aReadCharset)) {
                LOGGER.warn("The charset found in the CSS data (" + aReadCharset.name() + ") differs from the charset determined by the BOM (" + aBOMCharset.name() + ") -> Using the read charset");
            }
            Charset charset = aReadCharset;
            return charset;
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Failed to parse CSS charset definition", ex);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to parse CSS charset definition", ex);
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStream(aISP, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aFallbackCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromStream(aISP, new CSSReaderSettings().setFallbackCharset(aFallbackCharset).setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IHasInputStream aISP, @Nonnull CSSReaderSettings aSettings) {
        Charset aCharsetToUse;
        Charset aDeclaredCharset;
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        try {
            aDeclaredCharset = CSSReader.getCharsetDeclaredInCSS(aISP);
        }
        catch (IllegalStateException ex) {
            return null;
        }
        if (aDeclaredCharset != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reading CSS definition again with explicit charset '" + aDeclaredCharset.name() + "'");
            }
            aCharsetToUse = aDeclaredCharset;
        } else {
            aCharsetToUse = aSettings.getFallbackCharset();
        }
        InputStream aISOrig = aISP.getInputStream();
        if (aISOrig == null) {
            return null;
        }
        CharsetHelper.InputStreamAndCharset aISAndBOM = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)aISOrig);
        InputStream aIS = aISAndBOM.getInputStream();
        InputStreamReader aReader = StreamHelper.createReader((InputStream)aIS, (Charset)aCharsetToUse);
        ECSSVersion eVersion = aSettings.getCSSVersion();
        try {
            boolean bBrowserCompliantMode;
            CSSNode aNode;
            ICSSParseExceptionCallback aRealParseExceptionHandler;
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            aCharStream.setTabSize(aSettings.getTabSize());
            ICSSParseErrorHandler aRealParseErrorHandler = aSettings.getCustomErrorHandler();
            if (aRealParseErrorHandler == null) {
                aRealParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((aRealParseExceptionHandler = aSettings.getCustomExceptionHandler()) == null) {
                aRealParseExceptionHandler = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((aNode = CSSReader._readStyleSheet(aCharStream, eVersion, aRealParseErrorHandler, aRealParseExceptionHandler, bBrowserCompliantMode = aSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler aRealInterpretErrorHandler = aSettings.getInterpretErrorHandler();
            if (aRealInterpretErrorHandler == null) {
                aRealInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode, aRealInterpretErrorHandler);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader aRP, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReader.readFromReader(aRP, new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromReader(@Nonnull IHasReader aRP, @Nonnull CSSReaderSettings aSettings) {
        ValueEnforcer.notNull((Object)aRP, (String)"ReaderProvider");
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        Reader aReader = aRP.getReader();
        if (aReader == null) {
            return null;
        }
        ECSSVersion eVersion = aSettings.getCSSVersion();
        try {
            boolean bBrowserCompliantMode;
            CSSNode aNode;
            ICSSParseExceptionCallback aRealParseExceptionHandler;
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            aCharStream.setTabSize(aSettings.getTabSize());
            ICSSParseErrorHandler aRealParseErrorHandler = aSettings.getCustomErrorHandler();
            if (aRealParseErrorHandler == null) {
                aRealParseErrorHandler = CSSReader.getDefaultParseErrorHandler();
            }
            if ((aRealParseExceptionHandler = aSettings.getCustomExceptionHandler()) == null) {
                aRealParseExceptionHandler = CSSReader.getDefaultParseExceptionHandler();
            }
            if ((aNode = CSSReader._readStyleSheet(aCharStream, eVersion, aRealParseErrorHandler, aRealParseExceptionHandler, bBrowserCompliantMode = aSettings.isBrowserCompliantMode())) == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            ICSSInterpretErrorHandler aRealInterpretErrorHandler = aSettings.getInterpretErrorHandler();
            if (aRealInterpretErrorHandler == null) {
                aRealInterpretErrorHandler = CSSReader.getDefaultInterpretErrorHandler();
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eVersion, aNode, aRealInterpretErrorHandler);
            return cascadingStyleSheet;
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }
}

