/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class CSSReaderDeclarationList {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="s_aRWLock")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReaderDeclarationList s_aInstance = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return (ICSSParseErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler aDefaultParseErrorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseErrorHandler = aDefaultParseErrorHandler;
            return s_aDefaultParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return (ICSSParseExceptionCallback)s_aRWLock.readLocked(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback aDefaultParseExceptionHandler) {
        ValueEnforcer.notNull((Object)aDefaultParseExceptionHandler, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = aDefaultParseExceptionHandler;
            return s_aDefaultParseExceptionHandler;
        });
    }

    @Nonnull
    public static ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return (ICSSInterpretErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@Nonnull ICSSInterpretErrorHandler aDefaultErrorHandler) {
        ValueEnforcer.notNull((Object)aDefaultErrorHandler, (String)"DefaultErrorHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = aDefaultErrorHandler;
            return s_aDefaultInterpretErrorHandler;
        });
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream aCharStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nonnull ICSSParseExceptionCallback aCustomExceptionHandler) {
        switch (eVersion) {
            case CSS21: 
            case CSS30: {
                ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aCharStream);
                aTokenHdl.setCustomErrorHandler(aCustomErrorHandler);
                ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                aParser.setCustomErrorHandler(aCustomErrorHandler);
                try {
                    return aParser.styleDeclarationList();
                }
                catch (ParseException ex) {
                    aCustomExceptionHandler.onException(ex);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(aFile), aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aRes, (String)"Resource");
        ValueEnforcer.notNull((Object)aCharset, (String)"Charset");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        Reader aReader = aRes.getReader(aCharset);
        if (aReader == null) {
            LOGGER.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(aReader, eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        ValueEnforcer.notNull((Object)aCharset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)sCSS, (String)"CSS");
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        try {
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            CSSNode aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, CSSReaderDeclarationList.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback());
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), new CSSReaderSettings().setCSSVersion(eVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), new CSSReaderSettings().setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), new CSSReaderSettings().setCSSVersion(eVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, aCustomErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, null, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aISP, (String)"InputStreamProvider");
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), new CSSReaderSettings().setCSSVersion(eVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        ValueEnforcer.notNull((Object)aIS, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)aIS, (Charset)aCharset), new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader(aReader, new CSSReaderSettings().setCSSVersion(eVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(aReader, new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(aReader, new CSSReaderSettings().setCSSVersion(eVersion).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseErrorHandler aCustomErrorHandler, @Nullable ICSSParseExceptionCallback aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(aReader, new CSSReaderSettings().setCSSVersion(eVersion).setCustomErrorHandler(aCustomErrorHandler).setCustomExceptionHandler(aCustomExceptionHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull CSSReaderSettings aSettings) {
        ValueEnforcer.notNull((Object)aReader, (String)"Reader");
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        ECSSVersion eVersion = aSettings.getCSSVersion();
        try {
            CSSNode aNode;
            ICSSParseExceptionCallback aRealParseExceptionHandler;
            CSSCharStream aCharStream = new CSSCharStream(aReader);
            ICSSParseErrorHandler aRealParseErrorHandler = aSettings.getCustomErrorHandler();
            if (aRealParseErrorHandler == null) {
                aRealParseErrorHandler = CSSReaderDeclarationList.getDefaultParseErrorHandler();
            }
            if ((aRealParseExceptionHandler = aSettings.getCustomExceptionHandler()) == null) {
                aRealParseExceptionHandler = CSSReaderDeclarationList.getDefaultParseExceptionHandler();
            }
            if ((aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, aRealParseErrorHandler, aRealParseExceptionHandler)) == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            ICSSInterpretErrorHandler aRealInterpretErrorHandler = aSettings.getInterpretErrorHandler();
            if (aRealInterpretErrorHandler == null) {
                aRealInterpretErrorHandler = CSSReaderDeclarationList.getDefaultInterpretErrorHandler();
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eVersion, aNode, aRealInterpretErrorHandler);
            return cSSDeclarationList;
        }
        finally {
            StreamHelper.close((AutoCloseable)aReader);
        }
    }
}

