/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ReadOnlyToken;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSParseError {
    private final ReadOnlyToken m_aLastValidToken;
    private final String m_sExpectedTokens;
    private final ReadOnlyToken m_aFirstSkippedToken;
    private final ReadOnlyToken m_aLastSkippedToken;
    private final String m_sErrorMessage;

    public CSSParseError(@Nonnull @Nonempty String sErrorMsg) {
        ValueEnforcer.notEmpty((CharSequence)sErrorMsg, (String)"ErrorMsg");
        this.m_aLastValidToken = null;
        this.m_sExpectedTokens = null;
        this.m_aFirstSkippedToken = null;
        this.m_aLastSkippedToken = null;
        this.m_sErrorMessage = sErrorMsg;
    }

    public CSSParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) {
        ValueEnforcer.notNull((Object)aLastValidToken, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)aExpectedTokenSequencesVal, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)aTokenImageVal, (String)"TokenImageVal");
        this.m_aLastValidToken = new ReadOnlyToken(aLastValidToken);
        StringBuilder aExpected = new StringBuilder();
        for (int[] aExpectedTokens : aExpectedTokenSequencesVal) {
            if (aExpected.length() > 0) {
                aExpected.append(',');
            }
            for (int nExpectedToken : aExpectedTokens) {
                aExpected.append(' ').append(aTokenImageVal[nExpectedToken]);
            }
        }
        this.m_sExpectedTokens = aExpected.toString();
        this.m_aFirstSkippedToken = new ReadOnlyToken(aLastValidToken.next);
        this.m_aLastSkippedToken = aLastSkippedToken == null ? null : new ReadOnlyToken(aLastSkippedToken);
        this.m_sErrorMessage = LoggingCSSParseErrorHandler.createLoggingStringParseError(aLastValidToken, aExpectedTokenSequencesVal, aTokenImageVal, aLastSkippedToken);
    }

    @Nullable
    public ReadOnlyToken getLastValidToken() {
        return this.m_aLastValidToken;
    }

    @Nullable
    public String getExpectedTokens() {
        return this.m_sExpectedTokens;
    }

    @Nullable
    public ReadOnlyToken getFirstSkippedToken() {
        return this.m_aFirstSkippedToken;
    }

    @Nullable
    public ReadOnlyToken getLastSkippedToken() {
        return this.m_aLastSkippedToken;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("lastValidToken", (Object)this.m_aLastValidToken).appendIfNotNull("expectedTokens", (Object)this.m_sExpectedTokens).appendIfNotNull("firstSkippedToken", (Object)this.m_aFirstSkippedToken).appendIfNotNull("lastSkippedToken", (Object)this.m_aLastSkippedToken).append("errorMessage", (Object)this.m_sErrorMessage).getToString();
    }

    @Nonnull
    public static CSSParseError createUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(aCurrentToken, sRule, sMsg));
    }

    @Nonnull
    public static CSSParseError createBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(ex, aFromToken, aToToken));
    }

    @Nonnull
    public static CSSParseError createIllegalCharacter(char cIllegalChar) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(cIllegalChar));
    }
}

