/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.CSSParseError;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<CSSParseError> m_aErrors = new CommonsArrayList();

    @Override
    public void onCSSParseError(@Nonnull ParseException aParseEx, @Nullable Token aLastSkippedToken) throws ParseException {
        this.m_aRWLock.writeLocked(() -> {
            if (aParseEx.expectedTokenSequences == null) {
                this.m_aErrors.add((Object)new CSSParseError(aParseEx.getMessage()));
            } else {
                this.m_aErrors.add((Object)new CSSParseError(aParseEx.currentToken, aParseEx.expectedTokenSequences, aParseEx.tokenImage, aLastSkippedToken));
            }
        });
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createUnexpectedRule(aCurrentToken, sRule, sMsg)));
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createBrowserCompliantSkip(ex, aFromToken, aToToken)));
    }

    @Override
    public void onIllegalCharacter(char cIllegalChar) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createIllegalCharacter(cIllegalChar)));
    }

    @Nonnegative
    public boolean hasParseErrors() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.isNotEmpty());
    }

    @Nonnegative
    public int getParseErrorCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSParseError> getAllParseErrors() {
        return (ICommonsList)this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aErrors.getClone());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("errors", this.m_aErrors).getToString();
    }
}

