/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICSSParseErrorHandler {
    public void onCSSParseError(@Nonnull ParseException var1, @Nullable Token var2) throws ParseException;

    public void onCSSUnexpectedRule(@Nonnull Token var1, @Nonnull @Nonempty String var2, @Nonnull @Nonempty String var3) throws ParseException;

    public void onCSSBrowserCompliantSkip(@Nullable ParseException var1, @Nonnull Token var2, @Nonnull Token var3) throws ParseException;

    default public void onIllegalCharacter(char cIllegalChar) {
    }

    @Nonnull
    default public ICSSParseErrorHandler and(final @Nonnull ICSSParseErrorHandler aOther) {
        ValueEnforcer.notNull((Object)aOther, (String)"Other");
        final ICSSParseErrorHandler aThis = this;
        return new ICSSParseErrorHandler(){

            @Override
            public void onCSSParseError(@Nonnull ParseException aParseEx, @Nullable Token aLastSkippedToken) throws ParseException {
                aThis.onCSSParseError(aParseEx, aLastSkippedToken);
                aOther.onCSSParseError(aParseEx, aLastSkippedToken);
            }

            @Override
            public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
                aThis.onCSSUnexpectedRule(aCurrentToken, sRule, sMsg);
                aOther.onCSSUnexpectedRule(aCurrentToken, sRule, sMsg);
            }

            @Override
            public void onCSSBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) throws ParseException {
                aThis.onCSSBrowserCompliantSkip(ex, aFromToken, aToToken);
                aOther.onCSSBrowserCompliantSkip(ex, aFromToken, aToToken);
            }

            @Override
            public void onIllegalCharacter(char cIllegalChar) {
                aThis.onIllegalCharacter(cIllegalChar);
                aOther.onIllegalCharacter(cIllegalChar);
            }
        };
    }
}

