/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCSSParseErrorHandler.class);
    private static final int TOKEN_EOF = 0;

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull ParseException ex) {
        if (ex.currentToken == null) {
            return ex.getMessage();
        }
        return LoggingCSSParseErrorHandler.createLoggingStringParseError(ex.currentToken, ex.expectedTokenSequences, ex.tokenImage, null);
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringParseError(@Nonnull Token aLastValidToken, @Nonnull int[][] aExpectedTokenSequencesVal, @Nonnull String[] aTokenImageVal, @Nullable Token aLastSkippedToken) {
        ValueEnforcer.notNull((Object)aLastValidToken, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)aExpectedTokenSequencesVal, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)aTokenImageVal, (String)"TokenImageVal");
        StringBuilder aExpected = new StringBuilder();
        int nMaxSize = 0;
        for (int[] aExpectedTokens : aExpectedTokenSequencesVal) {
            if (nMaxSize < aExpectedTokens.length) {
                nMaxSize = aExpectedTokens.length;
            }
            if (aExpected.length() > 0) {
                aExpected.append(',');
            }
            for (int nExpectedToken : aExpectedTokens) {
                aExpected.append(' ').append(aTokenImageVal[nExpectedToken]);
            }
        }
        StringBuilder retval = new StringBuilder(1024);
        retval.append('[').append(aLastValidToken.next.beginLine).append(':').append(aLastValidToken.next.beginColumn).append(']');
        if (aLastSkippedToken != null) {
            retval.append("-[").append(aLastSkippedToken.endLine).append(':').append(aLastSkippedToken.endColumn).append(']');
        }
        retval.append(" Encountered");
        Token aCurToken = aLastValidToken.next;
        for (int i = 0; i < nMaxSize; ++i) {
            retval.append(' ');
            if (aCurToken.kind == 0) {
                retval.append(aTokenImageVal[0]);
                break;
            }
            retval.append("text '").append(aCurToken.image).append("' corresponding to token ").append(aTokenImageVal[aCurToken.kind]);
            aCurToken = aCurToken.next;
        }
        retval.append(". ");
        if (aLastSkippedToken != null) {
            retval.append("Skipped until token ").append(aLastSkippedToken).append(". ");
        }
        retval.append(aExpectedTokenSequencesVal.length == 1 ? "Was expecting:" : "Was expecting one of:").append((CharSequence)aExpected);
        return retval.toString();
    }

    @Override
    public void onCSSParseError(@Nonnull ParseException aParseEx, @Nullable Token aLastSkippedToken) throws ParseException {
        if (aParseEx.expectedTokenSequences == null) {
            LOGGER.warn(aParseEx.getMessage());
        } else {
            LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringParseError(aParseEx.currentToken, aParseEx.expectedTokenSequences, aParseEx.tokenImage, aLastSkippedToken));
        }
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) {
        return "[" + aCurrentToken.beginLine + ":" + aCurrentToken.beginColumn + "] Unexpected rule '" + sRule + "': " + sMsg;
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(aCurrentToken, sRule, sMsg));
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) {
        String ret = "Browser compliant mode skipped CSS from [" + aFromToken.beginLine + ":" + aFromToken.beginColumn + "] starting at token '" + aFromToken.image + "' until [" + aToToken.endLine + ":" + aToToken.endColumn + "] to token '" + aToToken.image + "'";
        if (ex != null) {
            ret = ret + " (based on " + ex.getClass().getName() + ": " + ex.getMessage() + ")";
        }
        return ret;
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) throws ParseException {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(ex, aFromToken, aToToken));
    }

    @Nonnull
    @Nonempty
    public static String createLoggingStringIllegalCharacter(char cIllegalChar) {
        return "Found illegal character: " + cIllegalChar + " (0x" + StringHelper.getHexStringLeadingZero((int)cIllegalChar, (int)4) + ")";
    }

    @Override
    public void onIllegalCharacter(char cIllegalChar) {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(cIllegalChar));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

