/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThrowingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    @Override
    public void onCSSParseError(@Nonnull ParseException aParseEx, @Nullable Token aLastSkippedToken) throws ParseException {
        throw aParseEx;
    }

    @Override
    public void onCSSUnexpectedRule(@Nonnull Token aCurrentToken, @Nonnull @Nonempty String sRule, @Nonnull @Nonempty String sMsg) throws ParseException {
        throw new ParseException(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(aCurrentToken, sRule, sMsg));
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException ex, @Nonnull Token aFromToken, @Nonnull Token aToToken) throws ParseException {
        if (ex != null) {
            throw ex;
        }
        throw new ParseException(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(null, aFromToken, aToToken));
    }

    @Override
    public void onIllegalCharacter(char cIllegalChar) {
        throw new IllegalStateException(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(cIllegalChar));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

