/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.tools;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools s_aInstance = new MediaQueryTools();

    private MediaQueryTools() {
    }

    @Nullable
    public static ICommonsList<CSSMediaQuery> parseToMediaQuery(@Nullable String sMediaQuery, @Nonnull ECSSVersion eVersion) {
        if (StringHelper.hasNoText((String)sMediaQuery)) {
            return null;
        }
        String sCSS = "@media " + sMediaQuery + " {}";
        CascadingStyleSheet aCSS = CSSReader.readFromString(sCSS, eVersion);
        if (aCSS == null) {
            return null;
        }
        CSSMediaRule aMediaRule = (CSSMediaRule)aCSS.getAllMediaRules().get(0);
        return aMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet aCSS, boolean bAllowNestedMediaQueries) {
        if (aCSS == null) {
            return false;
        }
        if (bAllowNestedMediaQueries) {
            return true;
        }
        return !aCSS.hasMediaRules();
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull CSSMediaQuery aMediaQuery, boolean bAllowNestedMediaQueries) {
        return MediaQueryTools.getWrappedInMediaQuery(aCSS, (Iterable<? extends CSSMediaQuery>)new CommonsArrayList((Object)aMediaQuery), bAllowNestedMediaQueries);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet aCSS, @Nonnull @Nonempty Iterable<? extends CSSMediaQuery> aMediaQueries, boolean bAllowNestedMediaQueries) {
        ValueEnforcer.notNull((Object)aCSS, (String)"CSS");
        ValueEnforcer.notEmpty(aMediaQueries, (String)"MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(aCSS, bAllowNestedMediaQueries)) {
            return null;
        }
        CascadingStyleSheet ret = new CascadingStyleSheet();
        for (CSSImportRule aImportRule : aCSS.getAllImportRules()) {
            if (aImportRule.hasMediaQueries()) {
                ret.addImportRule(aImportRule);
                continue;
            }
            CSSImportRule aNewImportRule = new CSSImportRule(aImportRule.getLocation());
            for (CSSMediaQuery aMediaQuery : aMediaQueries) {
                aNewImportRule.addMediaQuery(aMediaQuery);
            }
            ret.addImportRule(aNewImportRule);
        }
        for (CSSNamespaceRule aNamespaceRule : aCSS.getAllNamespaceRules()) {
            ret.addNamespaceRule(aNamespaceRule);
        }
        CSSMediaRule aNewMediaRule = new CSSMediaRule();
        for (CSSMediaQuery aMediaQuery : aMediaQueries) {
            aNewMediaRule.addMediaQuery(aMediaQuery);
        }
        for (ICSSTopLevelRule aRule : aCSS.getAllRules()) {
            aNewMediaRule.addRule(aRule);
        }
        ret.addRule(aNewMediaRule);
        return ret;
    }
}

