/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSHSL;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.CSSRGBA;
import com.helger.css.utils.ECSSColor;
import com.helger.css.utils.ECSSColorName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSColorHelper {
    public static final int RGB_MIN = 0;
    public static final int RGB_MAX = 255;
    public static final int RGB_RANGE = 256;
    public static final int HSL_MIN = 0;
    public static final int HSL_MAX = 359;
    public static final int HSL_RANGE = 360;
    public static final int PERCENTAGE_MIN = 0;
    public static final int PERCENTAGE_MAX = 100;
    public static final float OPACITY_MIN = 0.0f;
    public static final float OPACITY_MAX = 1.0f;
    @RegEx
    private static final String PATTERN_PART_VALUE = "((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)";
    @RegEx
    private static final String PATTERN_PART_PERCENTAGE = "((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))";
    @RegEx
    private static final String PATTERN_PART_OPACITY = "([0-9]*\\.[0-9]*|[0-9]+)";
    @RegEx
    private static final String PATTERN_RGB = "^rgb\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*\\)$";
    @RegEx
    private static final String PATTERN_RGBA = "^rgba\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSL = "^hsl\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSLA = "^hsla\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HEX = "^#[0-9a-fA-F]{1,6}$";
    private static final CSSColorHelper s_aInstance = new CSSColorHelper();

    private CSSColorHelper() {
    }

    public static boolean isColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasNoText((String)sRealValue)) {
            return false;
        }
        return CSSColorHelper.isRGBColorValue(sRealValue) || CSSColorHelper.isRGBAColorValue(sRealValue) || CSSColorHelper.isHSLColorValue(sRealValue) || CSSColorHelper.isHSLAColorValue(sRealValue) || CSSColorHelper.isHexColorValue(sRealValue) || ECSSColor.isDefaultColorName(sRealValue) || ECSSColorName.isDefaultColorName(sRealValue) || sRealValue.equals("currentColor") || sRealValue.equals("transparent");
    }

    public static boolean isRGBColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("rgb") && RegExHelper.stringMatchesPattern((String)PATTERN_RGB, (String)sRealValue);
    }

    @Nullable
    public static CSSRGB getParsedRGBColorValue(@Nullable String sValue) {
        String[] aValues;
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("rgb") && (aValues = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGB, (String)sRealValue)) != null) {
            return new CSSRGB(aValues[0], aValues[1], aValues[2]);
        }
        return null;
    }

    public static boolean isRGBAColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("rgba") && RegExHelper.stringMatchesPattern((String)PATTERN_RGBA, (String)sRealValue);
    }

    @Nullable
    public static CSSRGBA getParsedRGBAColorValue(@Nullable String sValue) {
        String[] aValues;
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("rgba") && (aValues = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGBA, (String)sRealValue)) != null) {
            return new CSSRGBA(aValues[0], aValues[1], aValues[2], aValues[3]);
        }
        return null;
    }

    public static boolean isHSLColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("hsl") && RegExHelper.stringMatchesPattern((String)PATTERN_HSL, (String)sRealValue);
    }

    @Nullable
    public static CSSHSL getParsedHSLColorValue(@Nullable String sValue) {
        String[] aValues;
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("hsl") && (aValues = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSL, (String)sRealValue)) != null) {
            return new CSSHSL(aValues[0], aValues[1], aValues[2]);
        }
        return null;
    }

    public static boolean isHSLAColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("hsla") && RegExHelper.stringMatchesPattern((String)PATTERN_HSLA, (String)sRealValue);
    }

    @Nullable
    public static CSSHSLA getParsedHSLAColorValue(@Nullable String sValue) {
        String[] aValues;
        String sRealValue = StringHelper.trim((String)sValue);
        if (StringHelper.hasText((String)sRealValue) && sRealValue.startsWith("hsla") && (aValues = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSLA, (String)sRealValue)) != null) {
            return new CSSHSLA(aValues[0], aValues[1], aValues[2], aValues[3]);
        }
        return null;
    }

    public static boolean isHexColorValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.hasText((String)sRealValue) && sRealValue.charAt(0) == '#' && RegExHelper.stringMatchesPattern((String)PATTERN_HEX, (String)sRealValue);
    }

    @Nonnegative
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private static int _mod(int nValue, int nMod) {
        int nPositiveValue;
        for (nPositiveValue = nValue; nPositiveValue < 0; nPositiveValue += nMod) {
        }
        return nPositiveValue % nMod;
    }

    @Nonnegative
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private static float _mod(float nValue, int nMod) {
        float nPositiveValue;
        for (nPositiveValue = nValue; nPositiveValue < 0.0f; nPositiveValue += (float)nMod) {
        }
        return nPositiveValue % (float)nMod;
    }

    @Nonnegative
    public static int getRGBValue(int nRGBPart) {
        return CSSColorHelper._mod(nRGBPart, 256);
    }

    @Nonnegative
    public static float getOpacityToUse(float fOpacity) {
        return fOpacity < 0.0f ? 0.0f : (fOpacity > 1.0f ? 1.0f : fOpacity);
    }

    @Nonnull
    @Nonempty
    public static String getRGBColorValue(int nRed, int nGreen, int nBlue) {
        return new StringBuilder(16).append("rgb(").append(CSSColorHelper.getRGBValue(nRed)).append(',').append(CSSColorHelper.getRGBValue(nGreen)).append(',').append(CSSColorHelper.getRGBValue(nBlue)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getRGBAColorValue(int nRed, int nGreen, int nBlue, float fOpacity) {
        return new StringBuilder(24).append("rgba(").append(CSSColorHelper.getRGBValue(nRed)).append(',').append(CSSColorHelper.getRGBValue(nGreen)).append(',').append(CSSColorHelper.getRGBValue(nBlue)).append(',').append(CSSColorHelper.getOpacityToUse(fOpacity)).append(")").toString();
    }

    @Nonnegative
    public static int getHSLHueValue(int nHSLPart) {
        return CSSColorHelper._mod(nHSLPart, 360);
    }

    @Nonnegative
    public static float getHSLHueValue(float fHSLPart) {
        return CSSColorHelper._mod(fHSLPart, 360);
    }

    @Nonnegative
    public static int getHSLPercentageValue(int nHSLPart) {
        return nHSLPart < 0 ? 0 : (nHSLPart > 100 ? 100 : nHSLPart);
    }

    @Nonnegative
    public static float getHSLPercentageValue(float nHSLPart) {
        return nHSLPart < 0.0f ? 0.0f : (nHSLPart > 100.0f ? 100.0f : nHSLPart);
    }

    @Nonnull
    @Nonempty
    public static String getHSLColorValue(int nHue, int nSaturation, int nLightness) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(nHue)).append(',').append(CSSColorHelper.getHSLPercentageValue(nSaturation)).append("%,").append(CSSColorHelper.getHSLPercentageValue(nLightness)).append("%").append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLColorValue(float fHue, float fSaturation, float fLightness) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(fHue)).append(',').append(CSSColorHelper.getHSLPercentageValue(fSaturation)).append("%,").append(CSSColorHelper.getHSLPercentageValue(fLightness)).append("%").append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLAColorValue(int nHue, int nSaturation, int nLightness, float fOpacity) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(nHue)).append(',').append(CSSColorHelper.getHSLPercentageValue(nSaturation)).append("%,").append(CSSColorHelper.getHSLPercentageValue(nLightness)).append("%,").append(CSSColorHelper.getOpacityToUse(fOpacity)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLAColorValue(float fHue, float fSaturation, float fLightness, float fOpacity) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(fHue)).append(',').append(CSSColorHelper.getHSLPercentageValue(fSaturation)).append("%,").append(CSSColorHelper.getHSLPercentageValue(fLightness)).append("%,").append(CSSColorHelper.getOpacityToUse(fOpacity)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    private static String _getRGBPartAsHexString(int nRGBPart) {
        return StringHelper.getHexStringLeadingZero((int)CSSColorHelper.getRGBValue(nRGBPart), (int)2);
    }

    @Nonnull
    @Nonempty
    public static String getHexColorValue(int nRed, int nGreen, int nBlue) {
        return new StringBuilder(7).append('#').append(CSSColorHelper._getRGBPartAsHexString(nRed)).append(CSSColorHelper._getRGBPartAsHexString(nGreen)).append(CSSColorHelper._getRGBPartAsHexString(nBlue)).toString();
    }

    @Nonnull
    @Nonempty
    public static float[] getRGBAsHSLValue(int nRed, int nGreen, int nBlue) {
        float hue;
        int cmin;
        int cmax;
        int n = cmax = nRed > nGreen ? nRed : nGreen;
        if (nBlue > cmax) {
            cmax = nBlue;
        }
        int n2 = cmin = nRed < nGreen ? nRed : nGreen;
        if (nBlue < cmin) {
            cmin = nBlue;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - nRed) / (float)(cmax - cmin);
            float greenc = (float)(cmax - nGreen) / (float)(cmax - cmin);
            float bluec = (float)(cmax - nBlue) / (float)(cmax - cmin);
            hue = nRed == cmax ? bluec - greenc : (nGreen == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue * 359.0f, saturation * 100.0f, brightness * 100.0f};
    }

    @Nonnull
    @Nonempty
    public static int[] getHSLAsRGBValue(float fHue, float fSaturation, float fLightness) {
        float hue = fHue / 359.0f;
        float saturation = fSaturation / 100.0f;
        float brightness = fLightness / 100.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new int[]{r, g, b};
    }
}

