/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.compare.IComparator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.css.ECSSUnit;
import com.helger.css.propertyvalue.CSSSimpleValueWithUnit;
import java.math.BigDecimal;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSNumberHelper {
    private static final ICommonsMap<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper s_aInstance;

    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String sCSSValue) {
        ValueEnforcer.notNull((Object)sCSSValue, (String)"CSSValue");
        return (ECSSUnit)s_aNameToUnitMap.findFirstValue(aEntry -> sCSSValue.endsWith((String)aEntry.getKey()));
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String sCSSValue) {
        ECSSUnit eUnit = CSSNumberHelper.getMatchingUnitInclPercentage(sCSSValue);
        return eUnit == null || eUnit == ECSSUnit.PERCENTAGE ? null : eUnit;
    }

    public static boolean isNumberValue(@Nullable String sCSSValue) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        return StringHelper.hasText((String)sRealValue) && StringParser.isDouble((String)sRealValue);
    }

    public static boolean isValueWithUnit(@Nullable String sCSSValue) {
        return CSSNumberHelper.isValueWithUnit(sCSSValue, true);
    }

    public static boolean isValueWithUnit(@Nullable String sCSSValue, boolean bWithPerc) {
        return CSSNumberHelper.getValueWithUnit(sCSSValue, bWithPerc) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String sCSSValue) {
        return CSSNumberHelper.getValueWithUnit(sCSSValue, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String sCSSValue, boolean bWithPerc) {
        String sRealValue = StringHelper.trim((String)sCSSValue);
        if (StringHelper.hasText((String)sRealValue)) {
            BigDecimal aValue;
            ECSSUnit eUnit;
            if (sRealValue.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit = eUnit = bWithPerc ? CSSNumberHelper.getMatchingUnitInclPercentage(sRealValue) : CSSNumberHelper.getMatchingUnitExclPercentage(sRealValue);
            if (eUnit != null && (aValue = StringParser.parseBigDecimal((String)(sRealValue = sRealValue.substring(0, sRealValue.length() - eUnit.getName().length()).trim()))) != null) {
                return new CSSSimpleValueWithUnit(aValue, eUnit);
            }
        }
        return null;
    }

    static {
        CommonsHashMap aNameToUnitMap = new CommonsHashMap();
        for (ECSSUnit eUnit : ECSSUnit.values()) {
            aNameToUnitMap.put((Object)eUnit.getName(), (Object)eUnit);
        }
        s_aNameToUnitMap = aNameToUnitMap.getSortedByKey((Comparator)IComparator.getComparatorStringLongestFirst());
        s_aInstance = new CSSNumberHelper();
    }
}

