/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor s_aInstance = new CSSCompressor();

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String sOriginalCSS, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(sOriginalCSS, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String sOriginalCSS, @Nonnull ECSSVersion eCSSVersion, boolean bRemoveUnnecessaryCode) {
        CSSWriterSettings aSettings = new CSSWriterSettings(eCSSVersion, true);
        aSettings.setRemoveUnnecessaryCode(bRemoveUnnecessaryCode);
        return CSSCompressor.getRewrittenCSS(sOriginalCSS, aSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String sOriginalCSS, @Nonnull CSSWriterSettings aSettings) {
        ValueEnforcer.notNull((Object)sOriginalCSS, (String)"OriginalCSS");
        ValueEnforcer.notNull((Object)aSettings, (String)"Settings");
        CascadingStyleSheet aCSS = CSSReader.readFromString(sOriginalCSS, aSettings.getVersion());
        if (aCSS != null) {
            try {
                return new CSSWriter(aSettings).getCSSAsString(aCSS);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to write optimized CSS!", (Throwable)ex);
            }
        }
        return sOriginalCSS;
    }
}

