/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.ENewLineMode;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWriterSettings
implements ICSSWriterSettings,
ICloneable<CSSWriterSettings> {
    public static final ICSSWriterSettings DEFAULT_SETTINGS = new CSSWriterSettings();
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    public static final boolean DEFAULT_REMOVE_UNNECESSARY_CODE = false;
    public static final ENewLineMode DEFAULT_NEW_LINE_MODE = ENewLineMode.UNIX;
    public static final String DEFAULT_INDENT = "  ";
    public static final boolean DEFAULT_QUOTE_URLS = false;
    public static final boolean DEFAULT_WRITE_NAMESPACE_RULES = true;
    public static final boolean DEFAULT_WRITE_FONT_FACE_RULES = true;
    public static final boolean DEFAULT_WRITE_KEYFRAMES_RULES = true;
    public static final boolean DEFAULT_WRITE_MEDIA_RULES = true;
    public static final boolean DEFAULT_WRITE_PAGE_RULES = true;
    public static final boolean DEFAULT_WRITE_VIEWPORT_RULES = true;
    public static final boolean DEFAULT_WRITE_SUPPORTS_RULES = true;
    public static final boolean DEFAULT_WRITE_UNKNOWN_RULES = true;
    private final ECSSVersion m_eVersion;
    private boolean m_bOptimizedOutput;
    private boolean m_bRemoveUnnecessaryCode = false;
    private ENewLineMode m_eNewLineMode = DEFAULT_NEW_LINE_MODE;
    private String m_sIndent = "  ";
    private boolean m_bQuoteURLs = false;
    private boolean m_bWriteNamespaceRules = true;
    private boolean m_bWriteFontFaceRules = true;
    private boolean m_bWriteKeyframesRules = true;
    private boolean m_bWriteMediaRules = true;
    private boolean m_bWritePageRules = true;
    private boolean m_bWriteViewportRules = true;
    private boolean m_bWriteSupportsRules = true;
    private boolean m_bWriteUnknownRules = true;

    public CSSWriterSettings() {
        this(ECSSVersion.LATEST, false);
    }

    public CSSWriterSettings(@Nonnull ECSSVersion eVersion) {
        this(eVersion, false);
    }

    public CSSWriterSettings(@Nonnull ECSSVersion eVersion, boolean bOptimizedOutput) {
        ValueEnforcer.notNull((Object)((Object)eVersion), (String)"Version");
        this.m_eVersion = eVersion;
        this.m_bOptimizedOutput = bOptimizedOutput;
    }

    public CSSWriterSettings(@Nonnull ICSSWriterSettings aBase) {
        ValueEnforcer.notNull((Object)aBase, (String)"Base");
        this.m_eVersion = aBase.getVersion();
        this.m_bOptimizedOutput = aBase.isOptimizedOutput();
        this.m_bRemoveUnnecessaryCode = aBase.isRemoveUnnecessaryCode();
        this.m_eNewLineMode = aBase.getNewLineMode();
        this.m_sIndent = aBase.getIndent(1);
        this.m_bQuoteURLs = aBase.isQuoteURLs();
        this.m_bWriteNamespaceRules = aBase.isWriteNamespaceRules();
        this.m_bWriteFontFaceRules = aBase.isWriteFontFaceRules();
        this.m_bWriteKeyframesRules = aBase.isWriteKeyframesRules();
        this.m_bWriteMediaRules = aBase.isWriteMediaRules();
        this.m_bWritePageRules = aBase.isWritePageRules();
        this.m_bWriteViewportRules = aBase.isWriteViewportRules();
        this.m_bWriteSupportsRules = aBase.isWriteSupportsRules();
        this.m_bWriteUnknownRules = aBase.isWriteUnknownRules();
    }

    @Override
    @Nonnull
    public final ECSSVersion getVersion() {
        return this.m_eVersion;
    }

    @Override
    public final boolean isOptimizedOutput() {
        return this.m_bOptimizedOutput;
    }

    @Nonnull
    public final CSSWriterSettings setOptimizedOutput(boolean bOptimizedOutput) {
        this.m_bOptimizedOutput = bOptimizedOutput;
        return this;
    }

    @Override
    public final boolean isRemoveUnnecessaryCode() {
        return this.m_bRemoveUnnecessaryCode;
    }

    @Nonnull
    public final CSSWriterSettings setRemoveUnnecessaryCode(boolean bRemoveUnnecessaryCode) {
        this.m_bRemoveUnnecessaryCode = bRemoveUnnecessaryCode;
        return this;
    }

    @Override
    @Nonnull
    public final ENewLineMode getNewLineMode() {
        return this.m_eNewLineMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getNewLineString() {
        return this.m_eNewLineMode.getText();
    }

    @Nonnull
    public final CSSWriterSettings setNewLineMode(@Nonnull ENewLineMode eNewLineMode) {
        this.m_eNewLineMode = (ENewLineMode)ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        return this;
    }

    @Override
    @Nonnull
    public final String getIndent(@Nonnegative int nCount) {
        return StringHelper.getRepeated((String)this.m_sIndent, (int)nCount);
    }

    @Nonnull
    public final CSSWriterSettings setIndent(@Nonnull String sIndent) {
        ValueEnforcer.notNull((Object)sIndent, (String)"Indent");
        this.m_sIndent = sIndent;
        return this;
    }

    @Override
    public final boolean isQuoteURLs() {
        return this.m_bQuoteURLs;
    }

    @Nonnull
    public final CSSWriterSettings setQuoteURLs(boolean bQuoteURLs) {
        this.m_bQuoteURLs = bQuoteURLs;
        return this;
    }

    @Override
    public final boolean isWriteNamespaceRules() {
        return this.m_bWriteNamespaceRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteNamespaceRules(boolean bWriteNamespaceRules) {
        this.m_bWriteNamespaceRules = bWriteNamespaceRules;
        return this;
    }

    @Override
    public final boolean isWriteFontFaceRules() {
        return this.m_bWriteFontFaceRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteFontFaceRules(boolean bWriteFontFaceRules) {
        this.m_bWriteFontFaceRules = bWriteFontFaceRules;
        return this;
    }

    @Override
    public final boolean isWriteKeyframesRules() {
        return this.m_bWriteKeyframesRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteKeyframesRules(boolean bWriteKeyframesRules) {
        this.m_bWriteKeyframesRules = bWriteKeyframesRules;
        return this;
    }

    @Override
    public final boolean isWriteMediaRules() {
        return this.m_bWriteMediaRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteMediaRules(boolean bWriteMediaRules) {
        this.m_bWriteMediaRules = bWriteMediaRules;
        return this;
    }

    @Override
    public final boolean isWritePageRules() {
        return this.m_bWritePageRules;
    }

    @Nonnull
    public final CSSWriterSettings setWritePageRules(boolean bWritePageRules) {
        this.m_bWritePageRules = bWritePageRules;
        return this;
    }

    @Override
    public final boolean isWriteViewportRules() {
        return this.m_bWriteViewportRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteViewportRules(boolean bWriteViewportRules) {
        this.m_bWriteViewportRules = bWriteViewportRules;
        return this;
    }

    @Override
    public final boolean isWriteSupportsRules() {
        return this.m_bWriteSupportsRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteSupportsRules(boolean bWriteSupportsRules) {
        this.m_bWriteSupportsRules = bWriteSupportsRules;
        return this;
    }

    @Override
    public final boolean isWriteUnknownRules() {
        return this.m_bWriteUnknownRules;
    }

    @Nonnull
    public final CSSWriterSettings setWriteUnknownRules(boolean bWriteUnknownRules) {
        this.m_bWriteUnknownRules = bWriteUnknownRules;
        return this;
    }

    @Override
    public void checkVersionRequirements(@Nonnull ICSSVersionAware aCSSObject) {
        ECSSVersion eMinCSSVersion = aCSSObject.getMinimumCSSVersion();
        if (this.m_eVersion.compareTo(eMinCSSVersion) < 0) {
            throw new IllegalStateException("This object cannot be serialized to CSS version " + this.m_eVersion.getVersion().getAsString() + " but requires at least " + eMinCSSVersion.getVersion().getAsString());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public CSSWriterSettings getClone() {
        return new CSSWriterSettings(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSWriterSettings rhs = (CSSWriterSettings)o;
        return this.m_eVersion.equals((Object)rhs.m_eVersion) && this.m_bOptimizedOutput == rhs.m_bOptimizedOutput && this.m_bRemoveUnnecessaryCode == rhs.m_bRemoveUnnecessaryCode && this.m_eNewLineMode.equals((Object)rhs.m_eNewLineMode) && this.m_sIndent.equals(rhs.m_sIndent) && this.m_bQuoteURLs == rhs.m_bQuoteURLs && this.m_bWriteNamespaceRules == rhs.m_bWriteNamespaceRules && this.m_bWriteFontFaceRules == rhs.m_bWriteFontFaceRules && this.m_bWriteKeyframesRules == rhs.m_bWriteKeyframesRules && this.m_bWriteMediaRules == rhs.m_bWriteMediaRules && this.m_bWritePageRules == rhs.m_bWritePageRules && this.m_bWriteViewportRules == rhs.m_bWriteViewportRules && this.m_bWriteSupportsRules == rhs.m_bWriteSupportsRules && this.m_bWriteUnknownRules == rhs.m_bWriteUnknownRules;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eVersion).append(this.m_bOptimizedOutput).append(this.m_bRemoveUnnecessaryCode).append((Enum)this.m_eNewLineMode).append((Object)this.m_sIndent).append(this.m_bQuoteURLs).append(this.m_bWriteNamespaceRules).append(this.m_bWriteFontFaceRules).append(this.m_bWriteKeyframesRules).append(this.m_bWriteMediaRules).append(this.m_bWritePageRules).append(this.m_bWriteViewportRules).append(this.m_bWriteSupportsRules).append(this.m_bWriteUnknownRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("version", (Enum)this.m_eVersion).append("optimizedOutput", this.m_bOptimizedOutput).append("removeUnnecessaryCode", this.m_bRemoveUnnecessaryCode).append("newLineMode", (Enum)this.m_eNewLineMode).append("indent", (Object)this.m_sIndent).append("quoteURLs", this.m_bQuoteURLs).append("writeNamespaceRules", this.m_bWriteNamespaceRules).append("writeFontFaceRules", this.m_bWriteFontFaceRules).append("writeKeyframesRules", this.m_bWriteKeyframesRules).append("writeMediaRules", this.m_bWriteMediaRules).append("writePageRules", this.m_bWritePageRules).append("writeViewportRules", this.m_bWriteViewportRules).append("writeSupportsRules", this.m_bWriteSupportsRules).append("writeUnknownRules", this.m_bWriteUnknownRules).getToString();
    }
}

