/*
 * Decompiled with CFR 0.152.
 */
package cocaine.hpack;

import cocaine.hpack.DynamicTable;
import cocaine.hpack.HeaderField;
import cocaine.hpack.StaticTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.Value;
import org.msgpack.type.ValueType;

public final class Decoder {
    private static final IOException DECOMPRESSION_EXCEPTION = new IOException("decompression failure");
    private final DynamicTable dynamicTable;
    public static final int DEFAULT_TABLE_SIZE = 4096;

    public Decoder(int maxHeaderTableSize) {
        this.dynamicTable = new DynamicTable(maxHeaderTableSize);
    }

    public List<HeaderField> decode(Value rawData) throws IOException {
        if (!rawData.isArrayValue()) {
            throw DECOMPRESSION_EXCEPTION;
        }
        ArrayList<HeaderField> parsedHeaders = new ArrayList<HeaderField>();
        ArrayValue rawHeaders = rawData.asArrayValue();
        for (Value rawHeader : rawHeaders) {
            if (rawHeader.isIntegerValue()) {
                int index = rawHeader.asIntegerValue().getInt();
                HeaderField header = this.getByIndex(index);
                parsedHeaders.add(header);
                continue;
            }
            if (rawHeader.getType() != ValueType.ARRAY) continue;
            Value[] headerArray = rawHeader.asArrayValue().getElementArray();
            if (headerArray.length != 3) {
                throw DECOMPRESSION_EXCEPTION;
            }
            byte[] name = headerArray[1].isIntegerValue() ? this.getByIndex((int)headerArray[1].asIntegerValue().getInt()).name : headerArray[1].asRawValue().getByteArray();
            byte[] value = headerArray[2].asRawValue().getByteArray();
            HeaderField header = new HeaderField(name, value);
            if (headerArray[0].asBooleanValue().getBoolean()) {
                this.dynamicTable.add(header);
            }
            parsedHeaders.add(header);
        }
        return parsedHeaders;
    }

    private HeaderField getByIndex(int index) {
        return index <= StaticTable.LENGTH ? StaticTable.getEntry(index) : this.dynamicTable.getEntry(index - StaticTable.LENGTH);
    }
}

