/*
 * Decompiled with CFR 0.152.
 */
package cocaine.hpack;

import cocaine.hpack.DynamicTable;
import cocaine.hpack.HeaderField;
import cocaine.hpack.HpackUtil;
import cocaine.hpack.StaticTable;
import java.io.IOException;
import org.msgpack.packer.Packer;

public final class Encoder {
    private final DynamicTable dynamicTable;

    public Encoder(int maxHeaderTableSize) {
        this.dynamicTable = new DynamicTable(maxHeaderTableSize);
    }

    public void encodeHeader(Packer packer, byte[] name, byte[] value, boolean store) throws IOException {
        HeaderField entry;
        int i;
        HeaderField headerField = new HeaderField(name, value);
        int nameIndex = 0;
        for (i = 1; i <= StaticTable.LENGTH; ++i) {
            entry = StaticTable.getEntry(i);
            if (entry == headerField) {
                packer.write(i);
                break;
            }
            if (!HpackUtil.equals(entry.name, headerField.name)) continue;
            nameIndex = i;
        }
        for (i = 1; i <= this.dynamicTable.length(); ++i) {
            entry = this.dynamicTable.getEntry(i);
            if (entry == headerField) {
                packer.write(i);
                break;
            }
            if (!HpackUtil.equals(entry.name, headerField.name)) continue;
            nameIndex = i;
        }
        packer.writeArrayBegin(3);
        packer.write(store);
        if (nameIndex != 0) {
            packer.write(nameIndex);
        } else {
            packer.write(name);
        }
        packer.write(value);
        packer.writeArrayEnd();
    }
}

