/*
 * Decompiled with CFR 0.152.
 */
package cocaine.hpack;

import cocaine.hpack.HpackUtil;
import java.nio.ByteBuffer;

public class HeaderField
implements Comparable<HeaderField> {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    public final byte[] name;
    public final byte[] value;

    public HeaderField(String name, String value) {
        this(name.getBytes(HpackUtil.ISO_8859_1), value.getBytes(HpackUtil.ISO_8859_1));
    }

    public HeaderField(byte[] name, byte[] value) {
        this.name = HpackUtil.requireNonNull(name);
        this.value = HpackUtil.requireNonNull(value);
    }

    public static byte[] valueFromLong(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    public static long toLong(byte[] value) {
        if (value.length != 8) {
            return 0L;
        }
        return ByteBuffer.wrap(value).getLong();
    }

    int size() {
        return this.name.length + this.value.length + 32;
    }

    @Override
    public int compareTo(HeaderField anotherHeaderField) {
        int ret = this.compareTo(this.name, anotherHeaderField.name);
        if (ret == 0) {
            ret = this.compareTo(this.value, anotherHeaderField.value);
        }
        return ret;
    }

    private int compareTo(byte[] s1, byte[] s2) {
        int len1 = s1.length;
        int len2 = s2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte b1 = s1[k];
            byte b2 = s2[k];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HeaderField)) {
            return false;
        }
        HeaderField other = (HeaderField)obj;
        boolean nameEquals = HpackUtil.equals(this.name, other.name);
        boolean valueEquals = HpackUtil.equals(this.value, other.value);
        return nameEquals && valueEquals;
    }

    public String toString() {
        String nameString = new String(this.name);
        String valueString = new String(this.value);
        return nameString + ": " + valueString;
    }
}

