/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.yandex.config.generator.AbstractConfigGenerator;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigField;
import ru.yandex.config.generator.FieldType;

public class AbstractBuilderConfigGenerator
extends AbstractConfigGenerator {
    private static final Set<String> RESERVED_METHODS = new LinkedHashSet<String>(Arrays.asList("build", "self"));
    private static final ClassOrInterfaceType T_TYPE = new ClassOrInterfaceType(null, "T");
    private final ClassOrInterfaceDeclaration builderClass;
    private final CompilationUnit unit;
    private final File builderFile;

    public AbstractBuilderConfigGenerator(Config config) throws IOException {
        super(config, config.abstractBuilderName());
        this.builderFile = new File(config.directory(), this.configName + ".java");
        if (this.builderFile.exists()) {
            this.unit = JavaParser.parse((File)this.builderFile);
            Optional optional = this.unit.getClassByName(this.configName);
            if (!optional.isPresent()) {
                throw new IOException(this.builderFile.getAbsolutePath() + " exists but do not contain class inside " + this.configName);
            }
            this.builderClass = (ClassOrInterfaceDeclaration)optional.get();
        } else {
            this.unit = new CompilationUnit(config.getPackage(), new NodeList((Collection)config.unit().getImports()), new NodeList(), null);
            this.builderClass = this.unit.addClass(this.configName);
            this.builderClass.setAbstract(true);
            this.builderClass.addTypeParameter(new TypeParameter("T", NodeList.nodeList((Node[])new ClassOrInterfaceType[]{new ClassOrInterfaceType(null, new SimpleName(this.configName), NodeList.nodeList((Node[])new Type[]{T_TYPE}))})));
            if (config.extendsName() != null) {
                String extendsClass = "Abstract" + config.extendsName() + "Builder";
                this.builderClass.addExtendedType(extendsClass + "<T>");
                this.unit.addImport(config.extendsPackage() + '.' + extendsClass);
            }
            this.builderClass.addImplementedType(config.name());
        }
    }

    @Override
    protected String fieldConfigString(ConfigField field) {
        return field.builderType().asString();
    }

    protected void handleImports() {
        NodeList imports = this.unit.getImports();
        imports.add(new ImportDeclaration("ru.yandex.parser.config.IniConfig", false, false));
        imports.add(new ImportDeclaration("ru.yandex.parser.config.ConfigException", false, false));
        imports.add(new ImportDeclaration("ru.yandex.parser.config.ConfigException", false, false));
        this.handleConfigsImports(this.config, (Collection<ImportDeclaration>)imports, false);
        this.handleCollectionsImports((Collection<ImportDeclaration>)imports);
        if (this.config.extendsName() != null) {
            this.handleImport(this.config.extendsName(), null, true, (Collection<ImportDeclaration>)imports);
        }
        this.unit.setImports(new NodeList((Collection)imports));
        this.adjustImports(this.unit);
    }

    protected void handleCollectionsImports(Collection<ImportDeclaration> imports) {
        for (ConfigField field : this.config.fields()) {
            switch (field.fieldType()) {
                case MAP: {
                    imports.add(MAP_IMPORT);
                    break;
                }
                case SET: {
                    imports.add(SET_IMPORT);
                    break;
                }
                case LIST: {
                    imports.add(LIST_IMPORT);
                }
            }
        }
    }

    protected void handleClassFields() {
        for (ConfigField field : this.config.fields()) {
            Optional optional = this.builderClass.getFieldByName(field.name());
            if (optional.isPresent()) continue;
            this.builderClass.addField(field.builderType(), field.name(), new Modifier[]{Modifier.PRIVATE});
        }
    }

    protected void handleFromConfigConstructor() {
        ConstructorDeclaration fromConfigContructor = null;
        for (ConstructorDeclaration md : this.builderClass.getConstructors()) {
            if (md.getParameters().size() != 1) continue;
            String first = md.getParameter(0).getType().asString();
            if (!this.config.name().equalsIgnoreCase(first)) continue;
            fromConfigContructor = md.asConstructorDeclaration();
            break;
        }
        if (fromConfigContructor == null) {
            fromConfigContructor = this.builderClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
            fromConfigContructor.addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, this.config.name()), new SimpleName("config")));
            NodeList constrStmts = new NodeList();
            constrStmts.add((Node)new ExplicitConstructorInvocationStmt(false, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config")})));
            for (ConfigField field : this.config.fields()) {
                constrStmts.add((Node)new ExpressionStmt((Expression)new MethodCallExpr(field.name(), new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), field.name())})));
            }
            fromConfigContructor.setBody(new BlockStmt(constrStmts));
        }
    }

    protected void handleFromIniConstructor() {
        ConstructorDeclaration fromIniConstructor = null;
        for (ConstructorDeclaration md : this.builderClass.getConstructors()) {
            if (md.getParameters().size() != 2) continue;
            String first = md.getParameter(0).getType().asString();
            String second = md.getParameter(1).getType().asString();
            if (!"IniConfig".equalsIgnoreCase(first) || !this.config.name().equalsIgnoreCase(second)) continue;
            fromIniConstructor = md.asConstructorDeclaration();
            break;
        }
        NodeList constrStmts = new NodeList();
        LinkedHashSet<String> initedFields = new LinkedHashSet<String>();
        if (fromIniConstructor == null) {
            fromIniConstructor = this.builderClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
            fromIniConstructor.addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, "IniConfig"), new SimpleName("config")));
            fromIniConstructor.addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, this.config.name()), new SimpleName("defaults")));
            fromIniConstructor.addThrownException((ReferenceType)new ClassOrInterfaceType(null, "ConfigException"));
            if (this.config.extendsName() != null) {
                constrStmts.add((Node)new ExplicitConstructorInvocationStmt(false, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config"), new NameExpr("defaults")})));
            }
        } else {
            constrStmts = fromIniConstructor.getBody().asBlockStmt().getStatements();
            for (Statement statement : constrStmts) {
                Expression target;
                Expression expression;
                if (!statement.isExpressionStmt() || !(expression = statement.asExpressionStmt().getExpression()).isAssignExpr() || !(target = expression.asAssignExpr().getTarget()).isFieldAccessExpr()) continue;
                initedFields.add(target.asFieldAccessExpr().getNameAsString());
            }
        }
        for (ConfigField field : this.config.fields()) {
            if (initedFields.contains(field.name())) continue;
            constrStmts.addAll(this.fieldIniConfigFetch(field));
        }
        fromIniConstructor.setBody(new BlockStmt(constrStmts));
    }

    protected void handleMethods() {
        Map fields = this.config.fields().stream().collect(Collectors.toMap(ConfigField::name, Function.identity()));
        Iterator methodIterator = this.builderClass.getMethods().iterator();
        LinkedHashSet<String> fieldsWithSetMethods = new LinkedHashSet<String>();
        LinkedHashSet<String> fieldsWithGetMethods = new LinkedHashSet<String>();
        while (methodIterator.hasNext()) {
            MethodDeclaration md = (MethodDeclaration)methodIterator.next();
            if (md.getModifiers().contains(Modifier.PRIVATE) || RESERVED_METHODS.contains(md.getNameAsString())) continue;
            String typeName = md.getTypeAsString();
            if (!fields.containsKey(md.getNameAsString())) {
                if (md.getParameters().size() == 0 && !md.getType().isVoidType()) {
                    if (!this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                    this.builderClass.remove((Node)md);
                    continue;
                }
                if (md.getParameters().size() != 1 || typeName.length() != 1 || !this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                this.builderClass.remove((Node)md);
                continue;
            }
            if (typeName.length() == 1 || this.configName.equalsIgnoreCase(typeName)) {
                fieldsWithSetMethods.add(md.getNameAsString());
                continue;
            }
            if (md.getParameters().size() == 0) {
                fieldsWithGetMethods.add(md.getNameAsString());
                continue;
            }
            if (!this.askUser("Delete method " + md.getNameAsString() + " with return type " + md.getType().asString() + " and params " + md.getParameters().toString())) continue;
            methodIterator.remove();
        }
        for (ConfigField field : this.config.fields()) {
            MethodDeclaration methodDeclaration;
            if (!fieldsWithGetMethods.contains(field.name())) {
                methodDeclaration = this.builderClass.addMethod(field.name(), new Modifier[]{Modifier.PUBLIC});
                methodDeclaration.setType(field.builderType());
                methodDeclaration.addAnnotation("Override");
                methodDeclaration.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new NameExpr(field.name()))));
            }
            if (fieldsWithSetMethods.contains(field.name())) continue;
            methodDeclaration = this.builderClass.addMethod(field.name(), new Modifier[]{Modifier.PUBLIC});
            methodDeclaration.setType((Type)new ClassOrInterfaceType(null, "T"));
            Parameter parameter = new Parameter(FINAL_MODIFIER, field.returnType(), new SimpleName("value"));
            methodDeclaration.addParameter(parameter);
            methodDeclaration.setBody(this.setMethodBody(field));
        }
    }

    @Override
    public CompilationUnit get() {
        this.handleImports();
        this.handleClassFields();
        this.handleFromConfigConstructor();
        this.handleFromIniConstructor();
        this.handleMethods();
        this.adjustImports(this.unit);
        this.adjustNodes(this.builderClass);
        return this.unit;
    }

    private String builderClass(ConfigField field) {
        if (field.fieldType() == FieldType.CONFIG) {
            return field.returnType().asClassOrInterfaceType().getName().asString() + "Builder";
        }
        return null;
    }

    private String fieldConfigName(ConfigField field) {
        String s = field.name();
        if (field.fieldType() == FieldType.CONFIG && s.endsWith("Config")) {
            s = s.replaceAll("Config", "");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c)) {
                sb.append('-');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Statement getConfigStatement(ConfigField field, String method, Expression parser) {
        NodeList args = new NodeList();
        args.add((Node)new StringLiteralExpr(this.fieldConfigName(field)));
        args.add((Node)new MethodCallExpr((Expression)new NameExpr("defaults"), new SimpleName(field.name())));
        if (parser != null) {
            args.add((Node)parser);
        }
        return new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new MethodCallExpr((Expression)new NameExpr("config"), method, args), AssignExpr.Operator.ASSIGN));
    }

    private Statement collectionIniConfigFetch(ConfigField field, String collection) {
        this.unit.addImport("ru.yandex.parser.string.CollectionParser");
        ObjectCreationExpr parser = new ObjectCreationExpr(null, new ClassOrInterfaceType(null, new SimpleName("CollectionParser"), new NodeList()), new NodeList((Node[])new Expression[]{new NameExpr("String::trim"), new NameExpr(collection + "::new")}));
        return this.getConfigStatement(field, "get", (Expression)parser);
    }

    private List<Statement> fieldIniConfigFetch(ConfigField field) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        switch (field.fieldType()) {
            case IMMUTABLE: {
                String methodName = "get";
                NameExpr parser = null;
                if (field.returnType().isPrimitiveType()) {
                    methodName = "get" + ConfigField.capitalize(field.returnType().asString());
                } else if (field.returnType().isClassOrInterfaceType() && field.returnType().asClassOrInterfaceType().isBoxedType()) {
                    methodName = "get" + field.returnType().asString();
                } else if (field.returnType().isClassOrInterfaceType()) {
                    String typeString = field.returnType().asString();
                    if ("String".equalsIgnoreCase(typeString)) {
                        methodName = "getString";
                    } else if ("Pattern".equalsIgnoreCase(typeString)) {
                        parser = new NameExpr("Pattern::compile");
                    } else if ("IniConfig".equalsIgnoreCase(typeString)) {
                        methodName = "sectionOrDefault";
                    }
                }
                statements.add(this.getConfigStatement(field, methodName, (Expression)parser));
                break;
            }
            case LIST: {
                statements.add(this.collectionIniConfigFetch(field, "ArrayList"));
                break;
            }
            case SET: {
                statements.add(this.collectionIniConfigFetch(field, "LinkedHashSet"));
                break;
            }
            case MAP: {
                statements.add(this.collectionIniConfigFetch(field, "LinkedHashMap"));
                break;
            }
            case CONFIG: {
                NodeList configBuilderArgs = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName("section"), NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(this.fieldConfigName(field))})), new MethodCallExpr((Expression)new NameExpr("defaults"), new SimpleName(field.name()))});
                statements.add((Statement)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new ObjectCreationExpr(null, new ClassOrInterfaceType(null, this.builderClass(field)), configBuilderArgs), AssignExpr.Operator.ASSIGN)));
            }
        }
        return statements;
    }

    private BlockStmt setMethodBody(ConfigField field) {
        switch (field.fieldType()) {
            case MAP: {
                this.unit.addImport(LinkedHashMap.class);
                return AbstractBuilderConfigGenerator.newObjectBlockStmt(field, AbstractBuilderConfigGenerator.byClassName(LinkedHashMap.class, field));
            }
            case SET: {
                this.unit.addImport(LinkedHashSet.class);
                return AbstractBuilderConfigGenerator.newObjectBlockStmt(field, AbstractBuilderConfigGenerator.byClassName(LinkedHashSet.class, field));
            }
            case LIST: {
                this.unit.addImport(ArrayList.class);
                return AbstractBuilderConfigGenerator.newObjectBlockStmt(field, AbstractBuilderConfigGenerator.byClassName(ArrayList.class, field));
            }
            case CONFIG: {
                return AbstractBuilderConfigGenerator.newObjectBlockStmt(field, new ClassOrInterfaceType(null, new SimpleName(this.builderClass(field)), (NodeList)field.returnType().asClassOrInterfaceType().getTypeArguments().orElse(null)));
            }
        }
        return AbstractBuilderConfigGenerator.expressionSetBlockStmt(field, (Expression)new NameExpr("value"));
    }

    protected static BlockStmt newObjectBlockStmt(ConfigField field, ClassOrInterfaceType type) {
        return AbstractBuilderConfigGenerator.expressionSetBlockStmt(field, (Expression)new ObjectCreationExpr(null, type, new NodeList((Node[])new Expression[]{new NameExpr("value")})));
    }

    protected static BlockStmt expressionSetBlockStmt(ConfigField field, Expression expression) {
        return (BlockStmt)((BlockStmt)new BlockStmt().addStatement((Statement)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), expression, AssignExpr.Operator.ASSIGN)))).addStatement((Statement)new ReturnStmt((Expression)new MethodCallExpr("self", new Expression[0])));
    }

    private static ClassOrInterfaceType byClassName(Class<?> clazz, ConfigField field) {
        return new ClassOrInterfaceType(null, new SimpleName(clazz.getSimpleName()), (NodeList)field.returnType().asClassOrInterfaceType().getTypeArguments().get());
    }

    public File file() {
        return this.builderFile;
    }
}

