/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.function.Supplier;
import ru.yandex.config.generator.CheckStylePrettyPrintVisitor;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigField;

public abstract class AbstractConfigGenerator
implements Supplier<CompilationUnit> {
    protected static final ImportDeclaration LIST_IMPORT = new ImportDeclaration("java.util.ArrayList", false, false);
    protected static final ImportDeclaration SET_IMPORT = new ImportDeclaration("java.util.LinkedHashSet", false, false);
    protected static final ImportDeclaration MAP_IMPORT = new ImportDeclaration("java.util.LinkedHashMap", false, false);
    protected static final EnumSet<Modifier> FINAL_MODIFIER = EnumSet.of(Modifier.FINAL);
    private static final PrettyPrinterConfiguration PRINTER_CONFIG = new PrettyPrinterConfiguration();
    protected final Config config;
    protected final String configName;

    public AbstractConfigGenerator(Config config, String configName) {
        this.config = config;
        this.configName = configName;
    }

    protected void process() throws IOException {
        String fileName = this.configName + ".java";
        File out = new File(this.config.directory(), fileName);
        if (out.exists()) {
            File tmp = new File("/tmp", fileName);
            Files.copy(Paths.get(out.toURI()), new FileOutputStream(tmp));
        }
        Files.write(Paths.get(out.toURI()), AbstractConfigGenerator.toString((CompilationUnit)this.get()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static String toString(CompilationUnit unit) {
        CheckStylePrettyPrintVisitor visitor = new CheckStylePrettyPrintVisitor(PRINTER_CONFIG);
        unit.accept((VoidVisitor)visitor, null);
        return visitor.getSource();
    }

    protected void handleCollectionsImport(Collection<ImportDeclaration> imports, Collection<ImportDeclaration> importsToAdd) {
        Iterator<ImportDeclaration> importsIter = imports.iterator();
        while (importsIter.hasNext()) {
            String name = importsIter.next().getNameAsString();
            if ("java.util.List".equalsIgnoreCase(name)) {
                importsIter.remove();
                importsToAdd.add(LIST_IMPORT);
            }
            if ("java.util.Set".equalsIgnoreCase(name)) {
                importsIter.remove();
                importsToAdd.add(SET_IMPORT);
            }
            if (!"java.util.Map".equalsIgnoreCase(name)) continue;
            importsIter.remove();
            importsToAdd.add(MAP_IMPORT);
        }
    }

    protected boolean askUser(String question) {
        Scanner reader = new Scanner(System.in);
        System.out.println(question);
        String answer = reader.next();
        return answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("Y");
    }

    protected ImportDeclaration handleImport(String expecting, String replacement, boolean delete, Collection<ImportDeclaration> decs) {
        Iterator<ImportDeclaration> iterator = decs.iterator();
        while (iterator.hasNext()) {
            ImportDeclaration dec = iterator.next();
            String name = dec.getNameAsString();
            CharSequence[] split = name.split("\\.");
            if (!split[split.length - 1].equalsIgnoreCase(expecting)) continue;
            if (delete) {
                iterator.remove();
            }
            if (replacement == null) continue;
            split[split.length - 1] = replacement;
            return new ImportDeclaration(String.join((CharSequence)".", split), false, false);
        }
        return null;
    }

    protected abstract String fieldConfigString(ConfigField var1);

    protected void handleConfigsImports(Config config, Collection<ImportDeclaration> imports, boolean deleteInterfaces) {
        for (ConfigField field : config.fields()) {
            switch (field.fieldType()) {
                case CONFIG: {
                    String replacement = this.fieldConfigString(field);
                    ImportDeclaration dec = this.handleImport(field.returnType().asString(), replacement, deleteInterfaces, imports);
                    if (dec == null) break;
                    imports.add(dec);
                    break;
                }
            }
        }
    }

    protected void adjustImports(CompilationUnit unit) {
        ArrayList<ImportDeclaration> decsList = new ArrayList<ImportDeclaration>((Collection<ImportDeclaration>)unit.getImports());
        Iterator iterator = decsList.iterator();
        LinkedHashSet<String> uniqueDecs = new LinkedHashSet<String>();
        while (iterator.hasNext()) {
            ImportDeclaration dec = (ImportDeclaration)iterator.next();
            if (dec.isAsterisk() || dec.isStatic()) continue;
            uniqueDecs.add(dec.getNameAsString());
            iterator.remove();
        }
        for (String dec : uniqueDecs) {
            decsList.add(new ImportDeclaration(dec, false, false));
        }
        unit.setImports(new NodeList(decsList));
    }

    protected void adjustNodes(ClassOrInterfaceDeclaration dec) {
        List fields = dec.getFields();
        List cntrs = dec.getConstructors();
        List mthds = dec.getMethods();
        NodeList list = new NodeList();
        list.addAll((Collection)fields);
        list.addAll((Collection)cntrs);
        list.addAll((Collection)mthds);
        dec.setMembers(list);
    }

    static {
        PRINTER_CONFIG.setColumnAlignParameters(true);
        PRINTER_CONFIG.setOrderImports(true);
    }
}

