/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.Position;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import com.github.javaparser.utils.Utils;
import java.util.Deque;
import java.util.LinkedList;

public class CheckStyleSourcePrinter {
    private final String endOfLineCharacter;
    private final String indentation;
    private final int tabWidth;
    private final PrettyPrinterConfiguration.IndentType indentType;
    private final Deque<String> indents = new LinkedList<String>();
    private final Deque<String> reindentedIndents = new LinkedList<String>();
    private String lastPrintedIndent = "";
    private final StringBuilder buf = new StringBuilder();
    private Position cursor = new Position(1, 0);
    private boolean indented = false;
    private int lastLineLen = 0;

    CheckStyleSourcePrinter() {
        this(new PrettyPrinterConfiguration());
    }

    CheckStyleSourcePrinter(PrettyPrinterConfiguration configuration) {
        this.indentation = configuration.getIndent();
        this.endOfLineCharacter = configuration.getEndOfLineCharacter();
        this.tabWidth = configuration.getTabWidth();
        this.indentType = configuration.getIndentType();
        this.indents.push("");
    }

    public CheckStyleSourcePrinter indent() {
        String currentIndent = this.indents.peek();
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                this.indents.push(currentIndent + this.indentation);
                break;
            }
            case TABS: {
                this.indents.push(this.indentation + currentIndent);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return this;
    }

    public CheckStyleSourcePrinter indentWithAlignTo(int column) {
        this.indents.push(this.calculateIndentWithAlignTo(column));
        return this;
    }

    private String calculateIndentWithAlignTo(int column) {
        if (column < this.lastPrintedIndent.length()) {
            throw new IllegalStateException("Attempt to indent less than the previous indent.");
        }
        StringBuilder newIndent = new StringBuilder(this.lastPrintedIndent);
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                while (newIndent.length() < column) {
                    newIndent.append(' ');
                }
                break;
            }
            case TABS: {
                int logicalIndentLength = newIndent.length();
                while (logicalIndentLength + this.tabWidth <= column) {
                    newIndent.insert(0, '\t');
                    logicalIndentLength += this.tabWidth;
                }
                while (logicalIndentLength < column) {
                    newIndent.append(' ');
                    ++logicalIndentLength;
                }
                StringBuilder fullTab = new StringBuilder();
                for (int i = 0; i < this.tabWidth; ++i) {
                    fullTab.append(' ');
                }
                String fullTabString = fullTab.toString();
                if (newIndent.length() < this.tabWidth || !newIndent.substring(newIndent.length() - this.tabWidth).equals(fullTabString)) break;
                int i = newIndent.indexOf(fullTabString);
                newIndent.replace(i, i + this.tabWidth, "\t");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return newIndent.toString();
    }

    public CheckStyleSourcePrinter unindent() {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("Indent/unindent calls are not well-balanced.");
        }
        this.indents.pop();
        return this;
    }

    private void append(String arg) {
        this.buf.append(arg);
        this.cursor = this.cursor.withColumn(this.cursor.column + arg.length());
    }

    public CheckStyleSourcePrinter print(String arg) {
        if (!this.indented) {
            this.lastPrintedIndent = this.indents.peek();
            this.append(this.lastPrintedIndent);
            this.indented = true;
        }
        this.append(arg);
        this.lastLineLen += arg.length();
        return this;
    }

    public CheckStyleSourcePrinter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public CheckStyleSourcePrinter println() {
        this.lastLineLen = 0;
        this.buf.append(this.endOfLineCharacter);
        this.cursor = Position.pos((int)(this.cursor.line + 1), (int)0);
        this.indented = false;
        return this;
    }

    public Position getCursor() {
        return this.cursor;
    }

    public String getSource() {
        return this.buf.toString();
    }

    public String toString() {
        return this.getSource();
    }

    public String normalizeEolInTextBlock(String content) {
        return Utils.normalizeEolInTextBlock((String)content, (String)this.endOfLineCharacter);
    }

    public void reindentWithAlignToCursor() {
        String newIndent = this.calculateIndentWithAlignTo(this.cursor.column);
        this.reindentedIndents.push(this.indents.pop());
        this.indents.push(newIndent);
    }

    public void reindentToPreviousLevel() {
        if (this.reindentedIndents.isEmpty()) {
            throw new IllegalStateException("Reindent calls are not well-balanced.");
        }
        this.indents.pop();
        this.indents.push(this.reindentedIndents.pop());
    }

    public void duplicateIndent() {
        this.indents.push(this.indents.peek());
    }

    public int indentSize() {
        return this.indents.peek().length();
    }
}

