/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.yandex.config.generator.ConfigField;
import ru.yandex.config.generator.FieldType;

public class Config {
    private final ClassOrInterfaceDeclaration configInterface;
    private final CompilationUnit unit;
    private final String name;
    private final File directory;
    private final PackageDeclaration packageDeclaration;
    private final List<ConfigField> fields;
    private final String extendsName;
    private final String extendsPackage;

    public Config(CompilationUnit unit, String name, File directory) throws IOException {
        this.unit = unit;
        this.name = name;
        this.directory = directory;
        Optional optionalClass = unit.getInterfaceByName(name);
        if (!optionalClass.isPresent()) {
            throw new IOException("No interface declared for " + name);
        }
        this.configInterface = (ClassOrInterfaceDeclaration)optionalClass.get();
        Optional packageOptional = unit.getPackageDeclaration();
        if (!packageOptional.isPresent()) {
            throw new IOException("Default package not allowe");
        }
        this.packageDeclaration = (PackageDeclaration)packageOptional.get();
        this.fields = new ArrayList<ConfigField>();
        for (MethodDeclaration dec : this.configInterface.getMethods()) {
            Type returnType = dec.getType();
            String methodName = dec.getNameAsString();
            FieldType fieldType = Config.detectFieldType(returnType);
            this.fields.add(new ConfigField(fieldType, methodName, returnType));
        }
        if (this.configInterface.getExtendedTypes().size() == 1) {
            this.extendsName = ((ClassOrInterfaceType)this.configInterface.getExtendedTypes().get(0)).getNameAsString();
            String extendsPackage = this.packageDeclaration.getNameAsString();
            for (ImportDeclaration dec : unit.getImports()) {
                String packName = dec.getNameAsString();
                if (!packName.contains(this.extendsName)) continue;
                int dotIndex = packName.lastIndexOf(46);
                if (dotIndex < 0) break;
                extendsPackage = packName.substring(0, dotIndex);
                break;
            }
            this.extendsPackage = extendsPackage;
        } else {
            this.extendsName = null;
            this.extendsPackage = null;
        }
    }

    public String defaultsName() {
        return this.name + "Defaults";
    }

    public ClassOrInterfaceType defaultsType() {
        return new ClassOrInterfaceType(null, this.defaultsName());
    }

    public String immutableName() {
        return "Immutable" + this.name;
    }

    public ClassOrInterfaceType immutableType() {
        return new ClassOrInterfaceType(null, this.immutableName());
    }

    public String builderName() {
        return this.name + "Builder";
    }

    public String abstractBuilderName() {
        return "Abstract" + this.name + "Builder";
    }

    public ClassOrInterfaceType builderType() {
        return new ClassOrInterfaceType(null, this.builderName());
    }

    public PackageDeclaration getPackage() {
        return this.packageDeclaration;
    }

    public CompilationUnit unit() {
        return this.unit;
    }

    public String name() {
        return this.name;
    }

    public File directory() {
        return this.directory;
    }

    public ClassOrInterfaceDeclaration configInterface() {
        return this.configInterface;
    }

    public List<ConfigField> fields() {
        return this.fields;
    }

    private static FieldType detectFieldType(Type returnType) {
        if (returnType.isClassOrInterfaceType()) {
            if (returnType.asString().endsWith("Config") && !returnType.asString().equalsIgnoreCase("IniConfig")) {
                return FieldType.CONFIG;
            }
            if ("Set".equalsIgnoreCase(returnType.asClassOrInterfaceType().getName().asString())) {
                return FieldType.SET;
            }
            if ("List".equalsIgnoreCase(returnType.asClassOrInterfaceType().getName().asString())) {
                return FieldType.LIST;
            }
            if ("Map".equalsIgnoreCase(returnType.asClassOrInterfaceType().getName().asString())) {
                return FieldType.MAP;
            }
        }
        return FieldType.IMMUTABLE;
    }

    public String extendsName() {
        return this.extendsName;
    }

    public String extendsPackage() {
        return this.extendsPackage;
    }
}

