/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import ru.yandex.config.generator.AbstractConfigGenerator;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigField;

public class ConfigBuilderGenerator
extends AbstractConfigGenerator {
    private final ClassOrInterfaceDeclaration configClass;
    private final CompilationUnit unit;
    private final File configFile;
    private final ClassOrInterfaceType interfaceType;

    public ConfigBuilderGenerator(Config config) throws IOException {
        super(config, config.builderName());
        this.interfaceType = new ClassOrInterfaceType(null, config.name());
        this.configFile = new File(config.directory(), this.configName + ".java");
        if (this.configFile.exists()) {
            this.unit = JavaParser.parse((File)this.configFile);
            Optional optional = this.unit.getClassByName(this.configName);
            if (!optional.isPresent()) {
                throw new IOException(this.configFile.getAbsolutePath() + " exists but do not contain class inside " + this.configName);
            }
            this.configClass = (ClassOrInterfaceDeclaration)optional.get();
        } else {
            this.unit = new CompilationUnit(config.getPackage(), new NodeList(), new NodeList(), null);
            this.configClass = this.unit.addClass(this.configName);
            this.configClass.addExtendedType(new ClassOrInterfaceType(null, new SimpleName("Abstract" + config.name() + "Builder"), new NodeList((Node[])new Type[]{new ClassOrInterfaceType(null, this.configName)})));
            this.unit.addImport("ru.yandex.parser.config.ConfigException");
            this.unit.addImport("ru.yandex.parser.config.IniConfig");
            this.addEmptyConstructor();
            this.addConfigConstructor();
            this.addIniConfigConstructor();
            this.addFullConstructor();
            this.addBuildMethod();
            this.addSelfMethod();
        }
    }

    protected void addEmptyConstructor() {
        this.configClass.addConstructor(new Modifier[]{Modifier.PUBLIC}).setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ExplicitConstructorInvocationStmt(true, null, NodeList.nodeList((Node[])new Expression[]{new FieldAccessExpr((Expression)new NameExpr(this.config.defaultsName()), "INSTANCE")}))})));
    }

    protected void addConfigConstructor() {
        ((ConstructorDeclaration)this.configClass.addConstructor(new Modifier[]{Modifier.PUBLIC}).addParameter(new Parameter(FINAL_MODIFIER, (Type)this.interfaceType, new SimpleName("config")))).setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ExplicitConstructorInvocationStmt(false, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config")}))})));
    }

    protected void addIniConfigConstructor() {
        BlockStmt body = new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ExplicitConstructorInvocationStmt(true, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config"), new FieldAccessExpr((Expression)new NameExpr(this.config.defaultsName()), "INSTANCE")}))}));
        ((ConstructorDeclaration)((ConstructorDeclaration)this.configClass.addConstructor(new Modifier[]{Modifier.PUBLIC}).addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, "IniConfig"), new SimpleName("config")))).addThrownException((ReferenceType)new ClassOrInterfaceType(null, "ConfigException"))).setBody(body);
    }

    protected void addFullConstructor() {
        BlockStmt body = new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ExplicitConstructorInvocationStmt(false, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config"), new NameExpr("defaults")}))}));
        ((ConstructorDeclaration)((ConstructorDeclaration)((ConstructorDeclaration)this.configClass.addConstructor(new Modifier[]{Modifier.PUBLIC}).addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, "IniConfig"), new SimpleName("config")))).addParameter(new Parameter(FINAL_MODIFIER, (Type)this.interfaceType, new SimpleName("defaults")))).addThrownException((ReferenceType)new ClassOrInterfaceType(null, "ConfigException"))).setBody(body);
    }

    protected void addBuildMethod() {
        ((MethodDeclaration)this.configClass.addMethod("build", new Modifier[]{Modifier.PUBLIC}).setType((Type)this.config.immutableType()).addThrownException((ReferenceType)new ClassOrInterfaceType(null, "ConfigException"))).setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ReturnStmt((Expression)new ObjectCreationExpr(null, this.config.immutableType(), NodeList.nodeList((Node[])new Expression[]{new ThisExpr()})))})));
    }

    protected void addSelfMethod() {
        ((MethodDeclaration)this.configClass.addMethod("self", new Modifier[]{Modifier.PROTECTED}).addAnnotation((AnnotationExpr)new MarkerAnnotationExpr("Override"))).setType((Type)this.config.builderType()).setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{new ReturnStmt((Expression)new ThisExpr())})));
    }

    @Override
    protected String fieldConfigString(ConfigField field) {
        return field.builderType().asString();
    }

    @Override
    public CompilationUnit get() {
        return this.unit;
    }
}

