/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import ru.yandex.config.generator.FieldType;

final class ConfigField {
    private final FieldType fieldType;
    private final String name;
    private final Type returnType;
    private final Type builderType;
    private final Type immutableType;
    private final Type defaultsType;

    public ConfigField(FieldType fieldType, String name, Type returnType) {
        this.fieldType = fieldType;
        this.name = name;
        this.returnType = returnType;
        if (fieldType == FieldType.CONFIG) {
            this.builderType = new ClassOrInterfaceType(null, returnType.asString() + "Builder");
            this.immutableType = new ClassOrInterfaceType(null, "Immutable" + returnType.asString());
            this.defaultsType = new ClassOrInterfaceType(null, returnType.asString() + "Defaults");
        } else {
            this.builderType = returnType;
            this.immutableType = returnType;
            this.defaultsType = returnType;
        }
    }

    public FieldType fieldType() {
        return this.fieldType;
    }

    public String name() {
        return this.name;
    }

    public Type returnType() {
        return this.returnType;
    }

    public Type builderType() {
        return this.builderType;
    }

    public Type immutableType() {
        return this.immutableType;
    }

    public Type defaultsType() {
        return this.defaultsType;
    }

    public static String capitalize(String name) {
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(name.charAt(0)));
        if (name.length() > 1) {
            result.append(name, 1, name.length());
        }
        return result.toString();
    }
}

