/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.util.ArrayList;
import ru.yandex.config.generator.AbstractBuilderConfigGenerator;
import ru.yandex.config.generator.AbstractConfigGenerator;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigBuilderGenerator;
import ru.yandex.config.generator.DefaultsConfigGenerator;
import ru.yandex.config.generator.ImmutableConfigGenerator;

public class ConfigGeneratorMain {
    public static void main(String[] args) throws Exception {
        File configFile = new File(args[0]);
        String configName = configFile.getName().split("\\.")[0];
        CompilationUnit unit = JavaParser.parse((File)configFile);
        Config config = new Config(unit, configName, configFile.getParentFile());
        ArrayList<AbstractConfigGenerator> generators = new ArrayList<AbstractConfigGenerator>();
        generators.add(new DefaultsConfigGenerator(config));
        generators.add(new AbstractBuilderConfigGenerator(config));
        generators.add(new ImmutableConfigGenerator(config));
        generators.add(new ConfigBuilderGenerator(config));
        for (AbstractConfigGenerator generator : generators) {
            generator.process();
        }
    }
}

