/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.yandex.config.generator.AbstractConfigGenerator;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigField;

public class DefaultsConfigGenerator
extends AbstractConfigGenerator {
    private final ClassOrInterfaceDeclaration configClass;
    private final CompilationUnit unit;
    private final File configFile;
    private final String extendsClass;

    public DefaultsConfigGenerator(Config config) throws IOException {
        super(config, config.defaultsName());
        this.configFile = new File(config.directory(), this.configName + ".java");
        this.extendsClass = config.extendsName() != null ? config.extendsName() + "Defaults" : null;
        if (this.configFile.exists()) {
            this.unit = JavaParser.parse((File)this.configFile);
            Optional optional = this.unit.getClassByName(this.configName);
            if (!optional.isPresent()) {
                throw new IOException(this.configFile.getAbsolutePath() + " exists but do not contain class inside " + this.configName);
            }
            this.configClass = (ClassOrInterfaceDeclaration)optional.get();
        } else {
            this.unit = new CompilationUnit(config.getPackage(), new NodeList((Collection)config.unit().getImports()), new NodeList(), null);
            this.configClass = this.unit.addClass(this.configName);
            if (this.extendsClass != null) {
                this.configClass.addExtendedType(this.extendsClass);
            }
            this.configClass.addImplementedType(config.name());
        }
    }

    @Override
    protected String fieldConfigString(ConfigField field) {
        return field.defaultsType().asString();
    }

    private void handleConstrustor() {
        boolean declared = false;
        for (ConstructorDeclaration md : this.configClass.getConstructors()) {
            if (md.getParameters().size() != 0) continue;
            declared = true;
            break;
        }
        if (!declared) {
            this.configClass.addConstructor(new Modifier[]{Modifier.PROTECTED}).setBody(new BlockStmt());
        }
    }

    private void handleFields() {
        Optional fd = this.configClass.getFieldByName("INSTANCE");
        if (!fd.isPresent()) {
            this.configClass.addFieldWithInitializer(this.configName, "INSTANCE", (Expression)new ObjectCreationExpr(null, new ClassOrInterfaceType(null, this.configName), NodeList.nodeList((Node[])new Expression[0])), new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        }
    }

    private void handleImports() {
        NodeList imports = this.unit.getImports();
        this.handleConfigsImports(this.config, (Collection<ImportDeclaration>)imports, false);
        ImportDeclaration dec = this.handleImport(this.config.extendsName(), this.extendsClass, true, (Collection<ImportDeclaration>)imports);
        if (dec != null) {
            imports.add(dec);
        }
        this.unit.setImports(new NodeList((Collection)imports));
        this.adjustImports(this.unit);
    }

    private void handleMethods() {
        Map fields = this.config.fields().stream().collect(Collectors.toMap(ConfigField::name, Function.identity()));
        Iterator methodIterator = this.configClass.getMethods().iterator();
        LinkedHashSet<String> fieldsWithGetMethods = new LinkedHashSet<String>();
        while (methodIterator.hasNext()) {
            MethodDeclaration md = (MethodDeclaration)methodIterator.next();
            if (md.getModifiers().contains(Modifier.PRIVATE)) continue;
            String typeName = md.getTypeAsString();
            if (!fields.containsKey(md.getNameAsString())) {
                if (md.getParameters().size() == 0 && !md.getType().isVoidType()) {
                    if (!this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                    this.configClass.remove((Node)md);
                    continue;
                }
                if (md.getParameters().size() != 1 || typeName.length() != 1 || !this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                this.configClass.remove((Node)md);
                continue;
            }
            if (md.getParameters().size() != 0) continue;
            fieldsWithGetMethods.add(md.getNameAsString());
        }
        for (ConfigField field : this.config.fields()) {
            if (fieldsWithGetMethods.contains(field.name())) continue;
            MethodDeclaration methodDeclaration = this.configClass.addMethod(field.name(), new Modifier[]{Modifier.PUBLIC});
            methodDeclaration.addAnnotation((AnnotationExpr)new MarkerAnnotationExpr("Override"));
            methodDeclaration.setType(field.returnType());
            NullLiteralExpr expression = new NullLiteralExpr();
            switch (field.fieldType()) {
                case CONFIG: {
                    expression = new FieldAccessExpr((Expression)new NameExpr(field.defaultsType().asString()), "INSTANCE");
                    break;
                }
                case SET: {
                    this.unit.addImport(Collections.class);
                    expression = new MethodCallExpr((Expression)new NameExpr("Collections"), "emptySet");
                    break;
                }
                case LIST: {
                    this.unit.addImport(Collections.class);
                    expression = new MethodCallExpr((Expression)new NameExpr("Collections"), "emptyList");
                    break;
                }
                case MAP: {
                    this.unit.addImport(Collections.class);
                    expression = new MethodCallExpr((Expression)new NameExpr("Collections"), "emptyMap");
                    break;
                }
            }
            methodDeclaration.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)expression)));
        }
    }

    @Override
    public CompilationUnit get() {
        this.handleImports();
        this.handleFields();
        this.handleConstrustor();
        this.handleMethods();
        this.adjustImports(this.unit);
        return this.unit;
    }
}

