/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.config.generator;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.yandex.config.generator.AbstractConfigGenerator;
import ru.yandex.config.generator.Config;
import ru.yandex.config.generator.ConfigField;

public class ImmutableConfigGenerator
extends AbstractConfigGenerator {
    private final ClassOrInterfaceDeclaration configClass;
    private final CompilationUnit unit;
    private final File configFile;

    public ImmutableConfigGenerator(Config config) throws IOException {
        super(config, config.immutableName());
        this.configFile = new File(config.directory(), this.configName + ".java");
        if (this.configFile.exists()) {
            this.unit = JavaParser.parse((File)this.configFile);
            Optional optional = this.unit.getClassByName(this.configName);
            if (!optional.isPresent()) {
                throw new IOException(this.configFile.getAbsolutePath() + " exists but do not contain class inside " + this.configName);
            }
            this.configClass = (ClassOrInterfaceDeclaration)optional.get();
        } else {
            this.unit = new CompilationUnit(config.getPackage(), new NodeList((Collection)config.unit().getImports()), new NodeList(), null);
            this.configClass = this.unit.addClass(this.configName);
            if (config.extendsName() != null) {
                String extendsClass = "Immutable" + config.extendsName();
                this.configClass.addExtendedType(extendsClass);
                this.unit.addImport(config.extendsPackage() + '.' + extendsClass);
            }
            this.configClass.addImplementedType(config.name());
        }
    }

    protected void handleImports() {
        NodeList imports = this.unit.getImports();
        imports.add(new ImportDeclaration("ru.yandex.parser.config.ConfigException", false, false));
        this.handleConfigsImports(this.config, (Collection<ImportDeclaration>)imports, true);
        if (this.config.extendsName() != null) {
            this.handleImport(this.config.extendsName(), null, true, (Collection<ImportDeclaration>)imports);
        }
        this.unit.setImports(new NodeList((Collection)imports));
        this.adjustImports(this.unit);
    }

    protected void handleConstrustor() {
        ConstructorDeclaration constructor = null;
        for (ConstructorDeclaration md : this.configClass.getConstructors()) {
            if (md.getParameters().size() != 1) continue;
            String first = md.getParameter(0).getType().asString();
            if (!this.config.name().equalsIgnoreCase(first)) continue;
            constructor = md.asConstructorDeclaration();
            break;
        }
        NodeList constrStmts = new NodeList();
        if (constructor == null) {
            constructor = this.configClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
            constructor.addParameter(new Parameter(FINAL_MODIFIER, (Type)new ClassOrInterfaceType(null, this.config.name()), new SimpleName("config")));
            constructor.addThrownException((ReferenceType)new ClassOrInterfaceType(null, "ConfigException"));
            constrStmts.add((Node)new ExplicitConstructorInvocationStmt(false, null, NodeList.nodeList((Node[])new Expression[]{new NameExpr("config")})));
        } else {
            constrStmts = constructor.getBody().asBlockStmt().getStatements();
        }
        LinkedHashSet<String> initedFields = new LinkedHashSet<String>();
        for (Statement statement : constrStmts) {
            Expression target;
            Expression expression;
            if (!statement.isExpressionStmt() || !(expression = statement.asExpressionStmt().getExpression()).isAssignExpr() || !(target = expression.asAssignExpr().getTarget()).isFieldAccessExpr()) continue;
            initedFields.add(target.asFieldAccessExpr().getNameAsString());
        }
        for (ConfigField field : this.config.fields()) {
            if (initedFields.contains(field.name())) continue;
            switch (field.fieldType()) {
                case CONFIG: {
                    NodeList args = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName(field.name()))});
                    constrStmts.add((Node)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new ObjectCreationExpr(null, new ClassOrInterfaceType(null, field.immutableType().asString()), args), AssignExpr.Operator.ASSIGN)));
                    break;
                }
                case SET: {
                    NodeList args = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName(field.name()))});
                    constrStmts.add((Node)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new MethodCallExpr(null, "Collections.unmodifiableSet", args), AssignExpr.Operator.ASSIGN)));
                    this.unit.addImport(Collections.class);
                    break;
                }
                case LIST: {
                    NodeList args = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName(field.name()))});
                    constrStmts.add((Node)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new MethodCallExpr(null, "Collections.unmodifiableList", args), AssignExpr.Operator.ASSIGN)));
                    this.unit.addImport(Collections.class);
                    break;
                }
                case MAP: {
                    NodeList args = new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName(field.name()))});
                    constrStmts.add((Node)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new MethodCallExpr(null, "Collections.unmodifiableMap", args), AssignExpr.Operator.ASSIGN)));
                    this.unit.addImport(Collections.class);
                    break;
                }
                case IMMUTABLE: {
                    constrStmts.add((Node)new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), field.name()), (Expression)new MethodCallExpr((Expression)new NameExpr("config"), new SimpleName(field.name())), AssignExpr.Operator.ASSIGN)));
                }
            }
        }
        constructor.setBody(new BlockStmt(constrStmts));
    }

    @Override
    protected String fieldConfigString(ConfigField field) {
        return field.immutableType().asString();
    }

    protected void handleMethods() {
        Map fields = this.config.fields().stream().collect(Collectors.toMap(ConfigField::name, Function.identity()));
        Iterator methodIterator = this.configClass.getMethods().iterator();
        LinkedHashSet<String> fieldsWithGetMethods = new LinkedHashSet<String>();
        while (methodIterator.hasNext()) {
            MethodDeclaration md = (MethodDeclaration)methodIterator.next();
            if (md.getModifiers().contains(Modifier.PRIVATE)) continue;
            String typeName = md.getTypeAsString();
            if (!fields.containsKey(md.getNameAsString())) {
                if (md.getParameters().size() == 0 && !md.getType().isVoidType()) {
                    if (!this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                    this.configClass.remove((Node)md);
                    continue;
                }
                if (md.getParameters().size() != 1 || typeName.length() != 1 || !this.askUser("Y/Yes remove method " + md.getNameAsString() + " from " + this.configName)) continue;
                this.configClass.remove((Node)md);
                continue;
            }
            if (md.getParameters().size() != 0) continue;
            fieldsWithGetMethods.add(md.getNameAsString());
        }
        for (ConfigField field : this.config.fields()) {
            if (fieldsWithGetMethods.contains(field.name())) continue;
            MethodDeclaration methodDeclaration = this.configClass.addMethod(field.name(), new Modifier[]{Modifier.PUBLIC});
            methodDeclaration.addAnnotation((AnnotationExpr)new MarkerAnnotationExpr("Override"));
            methodDeclaration.setType(field.immutableType());
            methodDeclaration.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new NameExpr(field.name()))));
        }
    }

    protected void handleClassFields() {
        for (ConfigField field : this.config.fields()) {
            Optional optional = this.configClass.getFieldByName(field.name());
            if (optional.isPresent()) continue;
            this.configClass.addField(field.immutableType(), field.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
    }

    @Override
    public CompilationUnit get() {
        this.handleImports();
        this.handleClassFields();
        this.handleConstrustor();
        this.handleMethods();
        this.adjustImports(this.unit);
        this.adjustNodes(this.configClass);
        return this.unit;
    }
}

