/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import org.anarres.lzo.AbstractLzoDecompressor;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.lzo_uintp;

public class LzoDecompressor1x_safe
extends AbstractLzoDecompressor {
    private static final int init = 0;
    private static final int copy_match = 1;
    private static final int eof_found = 2;
    private static final int first_literal_run = 3;
    private static final int match = 4;
    private static final int match_done = 5;
    private static final int match_next = 6;
    private static final int input_overrun = 7;
    private static final int output_overrun = 8;
    private static final int lookbehind_overrun = 9;

    public LzoDecompressor1x_safe() {
        super(LzoAlgorithm.LZO1X, LzoConstraint.SAFETY);
    }

    private static int UA_GET32(byte[] in, int in_ptr) {
        return (in[in_ptr] & 0xFF) << 24 | (in[in_ptr + 1] & 0xFF) << 16 | (in[in_ptr + 2] & 0xFF) << 8 | in[in_ptr + 3] & 0xFF;
    }

    public static int decompress(byte[] in, int in_base, int in_len, byte[] out, int out_base, lzo_uintp out_len, Object wrkmem) {
        int in_ptr = in_base;
        int out_ptr = out_base;
        int t = Integer.MIN_VALUE;
        int m_pos = Integer.MIN_VALUE;
        int ip_end = in_ptr + in_len;
        int op_end = out_ptr + out_len.value;
        int state = 0;
        out_len.value = 0;
        if ((in[in_ptr] & 0xFF) > 17) {
            if ((t = (in[in_ptr++] & 0xFF) - 17) < 4) {
                state = 6;
            } else {
                assert (t > 0) : "Assertion failed: t > 0";
                if (op_end - out_ptr < t) {
                    state = 8;
                } else if (ip_end - in_ptr < t + 1) {
                    state = 7;
                } else {
                    do {
                        out[out_ptr++] = in[in_ptr++];
                    } while (--t > 0);
                    state = 3;
                }
            }
        }
        block20: while (in_ptr < ip_end) {
            switch (state) {
                case 0: {
                    t = in[in_ptr++] & 0xFF;
                    if (t >= 16) {
                        state = 4;
                        break;
                    }
                    if (t == 0) {
                        if (ip_end - in_ptr < 1) {
                            state = 7;
                            break block20;
                        }
                        while (in[in_ptr] == 0) {
                            t += 255;
                            if (ip_end - ++in_ptr >= 1) continue;
                            state = 7;
                            break block20;
                        }
                        t += 15 + (in[in_ptr++] & 0xFF);
                    }
                    assert (t > 0) : "Assertion failed: t > 0";
                    if (op_end - out_ptr < t + 3) {
                        state = 8;
                        break block20;
                    }
                    if (ip_end - in_ptr < t + 4) {
                        state = 7;
                        break block20;
                    }
                    t += 3;
                    do {
                        out[out_ptr++] = in[in_ptr++];
                    } while (--t > 0);
                }
                case 3: {
                    t = in[in_ptr++] & 0xFF;
                    if (t >= 16) {
                        state = 4;
                        break;
                    }
                    m_pos = out_ptr - 2049;
                    m_pos -= t >> 2;
                    if ((m_pos -= (in[in_ptr++] & 0xFF) << 2) < out_base || m_pos >= out_ptr) {
                        state = 9;
                        break block20;
                    }
                    if (op_end - out_ptr < 3) {
                        state = 8;
                        break block20;
                    }
                    out[out_ptr++] = out[m_pos++];
                    out[out_ptr++] = out[m_pos++];
                    out[out_ptr++] = out[m_pos];
                    state = 5;
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break block20;
                }
                default: {
                    throw new IllegalStateException("Illegal state " + state);
                }
            }
            block23: while (true) {
                switch (state) {
                    case 0: 
                    case 4: {
                        if (t >= 64) {
                            m_pos = out_ptr - 1;
                            m_pos -= t >> 2 & 7;
                            int n = in_ptr++;
                            t = (t >> 5) - 1;
                            if ((m_pos -= (in[n] & 0xFF) << 3) < out_base || m_pos >= out_ptr) {
                                state = 9;
                                break block20;
                            }
                            assert (t > 0) : "Assertion failed: t > 0";
                            if (op_end - out_ptr < t + 3 - 1) {
                                state = 8;
                                break block20;
                            }
                            state = 1;
                            continue block23;
                        }
                        if (t >= 32) {
                            if ((t &= 0x1F) == 0) {
                                if (ip_end - in_ptr < 1) {
                                    state = 7;
                                    break block20;
                                }
                                while (in[in_ptr] == 0) {
                                    t += 255;
                                    if (ip_end - ++in_ptr >= 1) continue;
                                    state = 7;
                                    break block20;
                                }
                                t += 31 + (in[in_ptr++] & 0xFF);
                            }
                            m_pos = out_ptr - 1;
                            m_pos -= ((in[in_ptr] & 0xFF) >> 2) + ((in[in_ptr + 1] & 0xFF) << 6);
                            in_ptr += 2;
                        } else if (t >= 16) {
                            m_pos = out_ptr;
                            m_pos -= (t & 8) << 11;
                            if ((t &= 7) == 0) {
                                if (ip_end - in_ptr < 1) {
                                    state = 7;
                                    break block20;
                                }
                                while (in[in_ptr] == 0) {
                                    t += 255;
                                    if (ip_end - ++in_ptr >= 1) continue;
                                    state = 7;
                                    break block20;
                                }
                                t += 7 + (in[in_ptr++] & 0xFF);
                            }
                            if ((m_pos -= ((in[in_ptr += 2] & 0xFF) >> 2) + ((in[in_ptr + 1] & 0xFF) << 6)) == out_ptr) {
                                state = 2;
                                break block20;
                            }
                            m_pos -= 16384;
                        } else {
                            m_pos = out_ptr - 1;
                            m_pos -= t >> 2;
                            if ((m_pos -= (in[in_ptr++] & 0xFF) << 2) < out_base || m_pos >= out_ptr) {
                                state = 9;
                                break block20;
                            }
                            if (op_end - out_ptr < 2) {
                                state = 8;
                                break block20;
                            }
                            out[out_ptr++] = out[m_pos++];
                            out[out_ptr++] = out[m_pos];
                            state = 5;
                            continue block23;
                        }
                        if (m_pos < out_base || m_pos >= out_ptr) {
                            state = 9;
                            break block20;
                        }
                        assert (t > 0) : "Assertion failed: t > 0";
                        if (op_end - out_ptr < t + 3 - 1) {
                            state = 8;
                            break block20;
                        }
                    }
                    case 1: {
                        t += 2;
                        do {
                            out[out_ptr++] = out[m_pos++];
                        } while (--t > 0);
                    }
                    case 5: {
                        t = in[in_ptr - 2] & 3;
                        if (t == 0) break block23;
                    }
                    case 6: {
                        assert (t > 0) : "Assertion failed: t > 0";
                        assert (t < 4) : "Assertion failed: t < 4";
                        if (op_end - out_ptr < t) {
                            state = 8;
                            break block20;
                        }
                        if (ip_end - in_ptr < t + 1) {
                            state = 7;
                            break block20;
                        }
                        do {
                            out[out_ptr++] = in[in_ptr++];
                        } while (--t > 0);
                        t = in[in_ptr++] & 0xFF;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal state " + state);
                    }
                }
                state = 0;
                if (in_ptr >= ip_end) break;
            }
            state = 0;
        }
        switch (state) {
            case 0: {
                out_len.value = out_ptr - out_base;
                return -7;
            }
            case 2: {
                assert (t == 1) : "Assertion failed: t == 1";
                out_len.value = out_ptr - out_base;
                return in_ptr == ip_end ? 0 : (in_ptr < ip_end ? -8 : -4);
            }
            case 7: {
                out_len.value = out_ptr - out_base;
                return -4;
            }
            case 8: {
                out_len.value = out_ptr - out_base;
                return -5;
            }
            case 9: {
                out_len.value = out_ptr - out_base;
                return -6;
            }
        }
        throw new IllegalStateException("Illegal state " + state);
    }

    public int decompress(byte[] in, int in_base, int in_len, byte[] out, int out_base, lzo_uintp out_len) {
        return LzoDecompressor1x_safe.decompress(in, in_base, in_len, out, out_base, out_len, null);
    }
}

