/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoCompressor1x_1;
import org.anarres.lzo.LzoCompressor1x_999;
import org.anarres.lzo.LzoCompressor1y_1;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.LzoDecompressor1x;
import org.anarres.lzo.LzoDecompressor1x_safe;
import org.anarres.lzo.LzoDecompressor1y;
import org.anarres.lzo.LzoDecompressor1y_safe;
import org.anarres.lzo.LzoDecompressor1z;
import org.anarres.lzo.LzoDecompressor1z_safe;

public class LzoLibrary {
    @Nonnull
    public static LzoLibrary getInstance() {
        return Inner.INSTANCE;
    }

    @Nonnull
    public LzoCompressor newCompressor(@CheckForNull LzoAlgorithm algorithm, @CheckForNull LzoConstraint constraint) {
        if (algorithm == null) {
            return new LzoCompressor1x_1();
        }
        switch (algorithm) {
            case LZO1X: {
                if (constraint == null) {
                    return new LzoCompressor1x_1();
                }
                if (constraint == LzoConstraint.COMPRESSION) {
                    return new LzoCompressor1x_999(7);
                }
                throw new UnsupportedOperationException("Unsupported combination " + (Object)((Object)algorithm) + "/" + (Object)((Object)constraint));
            }
            case LZO1Y: {
                if (constraint == null) {
                    return new LzoCompressor1y_1();
                }
                throw new UnsupportedOperationException("Unsupported combination " + (Object)((Object)algorithm) + "/" + (Object)((Object)constraint));
            }
        }
        throw new UnsupportedOperationException("Unsupported algorithm " + (Object)((Object)algorithm));
    }

    @Nonnull
    public LzoDecompressor newDecompressor(@Nonnull LzoAlgorithm algorithm, @CheckForNull LzoConstraint constraint) {
        if (algorithm == null) {
            throw new NullPointerException("No algorithm specified.");
        }
        switch (algorithm) {
            case LZO1X: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1x_safe();
                }
                return new LzoDecompressor1x();
            }
            case LZO1Y: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1y_safe();
                }
                return new LzoDecompressor1y();
            }
            case LZO1Z: {
                if (constraint == LzoConstraint.SAFETY) {
                    return new LzoDecompressor1z_safe();
                }
                return new LzoDecompressor1z();
            }
        }
        throw new UnsupportedOperationException("Unsupported algorithm " + (Object)((Object)algorithm));
    }

    private static class Inner {
        private static final LzoLibrary INSTANCE = new LzoLibrary();

        private Inner() {
        }
    }
}

