/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoDecompressor1x;
import org.anarres.lzo.LzoInputStream;
import org.anarres.lzo.LzopConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LzopInputStream
extends LzoInputStream {
    private static final Log LOG = LogFactory.getLog(LzopInputStream.class);
    private final int flags = this.readHeader();
    private final CRC32 c_crc32_c = ((long)this.flags & 0x200L) == 0L ? null : new CRC32();
    private final CRC32 c_crc32_d = ((long)this.flags & 0x100L) == 0L ? null : new CRC32();
    private final Adler32 c_adler32_c = ((long)this.flags & 2L) == 0L ? null : new Adler32();
    private final Adler32 c_adler32_d = ((long)this.flags & 1L) == 0L ? null : new Adler32();
    private boolean eof = false;

    public LzopInputStream(@Nonnull InputStream in) throws IOException {
        super(in, new LzoDecompressor1x());
    }

    public int getFlags() {
        return this.flags;
    }

    @Nonnegative
    public int getCompressedChecksumCount() {
        int out = 0;
        if (this.c_crc32_c != null) {
            ++out;
        }
        if (this.c_adler32_c != null) {
            ++out;
        }
        return out;
    }

    @Nonnegative
    public int getUncompressedChecksumCount() {
        int out = 0;
        if (this.c_crc32_d != null) {
            ++out;
        }
        if (this.c_adler32_d != null) {
            ++out;
        }
        return out;
    }

    protected void logState(@Nonnull String when) {
        super.logState(when);
        LOG.info((Object)(when + " Flags = " + Integer.toHexString(this.flags)));
    }

    private int readInt(@Nonnull byte[] buf, @Nonnegative int len) throws IOException {
        this.readBytes(buf, 0, len);
        int ret = (0xFF & buf[0]) << 24;
        ret |= (0xFF & buf[1]) << 16;
        ret |= (0xFF & buf[2]) << 8;
        return len > 3 ? ret : (ret |= 0xFF & buf[3]) >>> 8 * (4 - len);
    }

    private int readHeaderItem(@Nonnull byte[] buf, @Nonnegative int len, @Nonnull Adler32 adler, @Nonnull CRC32 crc32) throws IOException {
        int ret = this.readInt(buf, len);
        adler.update(buf, 0, len);
        crc32.update(buf, 0, len);
        Arrays.fill(buf, (byte)0);
        return ret;
    }

    protected int readHeader() throws IOException {
        boolean extraField;
        byte[] buf = new byte[9];
        this.readBytes(buf, 0, 9);
        if (!Arrays.equals(buf, LzopConstants.LZOP_MAGIC)) {
            throw new IOException("Invalid LZO header");
        }
        Arrays.fill(buf, (byte)0);
        Adler32 adler = new Adler32();
        CRC32 crc32 = new CRC32();
        int hitem = this.readHeaderItem(buf, 2, adler, crc32);
        if (hitem > 4112) {
            LOG.debug((Object)("Compressed with later version of lzop: " + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")"));
        }
        if ((hitem = this.readHeaderItem(buf, 2, adler, crc32)) > 8272) {
            throw new IOException("Compressed with incompatible lzo version: 0x" + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(8272) + ")");
        }
        hitem = this.readHeaderItem(buf, 2, adler, crc32);
        if (hitem > 4112) {
            throw new IOException("Compressed with incompatible lzop version: 0x" + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")");
        }
        hitem = this.readHeaderItem(buf, 1, adler, crc32);
        switch (hitem) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IOException("Invalid strategy " + Integer.toHexString(hitem));
            }
        }
        this.readHeaderItem(buf, 1, adler, crc32);
        int flags = this.readHeaderItem(buf, 4, adler, crc32);
        boolean useCRC32 = ((long)flags & 0x1000L) != 0L;
        boolean bl = extraField = ((long)flags & 0x40L) != 0L;
        if (((long)flags & 0x400L) != 0L) {
            throw new IOException("Multipart lzop not supported");
        }
        if (((long)flags & 0x800L) != 0L) {
            throw new IOException("lzop filter not supported");
        }
        if (((long)flags & 0xFC000L) != 0L) {
            throw new IOException("Unknown flags in header");
        }
        this.readHeaderItem(buf, 4, adler, crc32);
        this.readHeaderItem(buf, 4, adler, crc32);
        this.readHeaderItem(buf, 4, adler, crc32);
        hitem = this.readHeaderItem(buf, 1, adler, crc32);
        if (hitem > 0) {
            byte[] tmp = hitem > buf.length ? new byte[hitem] : buf;
            this.readHeaderItem(tmp, hitem, adler, crc32);
        }
        int checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
        hitem = this.readHeaderItem(buf, 4, adler, crc32);
        if (hitem != checksum) {
            throw new IOException("Invalid header checksum: " + Long.toHexString(checksum) + " (expected 0x" + Integer.toHexString(hitem) + ")");
        }
        if (extraField) {
            LOG.debug((Object)"Extra header field not processed");
            adler.reset();
            crc32.reset();
            hitem = this.readHeaderItem(buf, 4, adler, crc32);
            this.readHeaderItem(new byte[hitem], hitem, adler, crc32);
            checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
            if (checksum != this.readHeaderItem(buf, 4, adler, crc32)) {
                throw new IOException("Invalid checksum for extra header field");
            }
        }
        return flags;
    }

    private int readChecksum(@CheckForNull Checksum csum) throws IOException {
        if (csum == null) {
            return 0;
        }
        return this.readInt(false);
    }

    private void testChecksum(@CheckForNull Checksum csum, int value, @Nonnull byte[] data, @Nonnegative int off, @Nonnegative int len) throws IOException {
        if (csum == null) {
            return;
        }
        csum.reset();
        csum.update(data, off, len);
        if (value != (int)csum.getValue()) {
            throw new IOException("Checksum failure: Expected " + Integer.toHexString(value) + "; got " + Long.toHexString(csum.getValue()));
        }
    }

    protected boolean readBlock() throws IOException {
        if (this.eof) {
            return false;
        }
        int outputBufferLength = this.readInt(false);
        if (outputBufferLength == 0) {
            this.eof = true;
            return false;
        }
        this.setOutputBufferSize(outputBufferLength);
        int inputBufferLength = this.readInt(false);
        this.setInputBufferSize(inputBufferLength);
        int v_adler32_d = this.readChecksum(this.c_adler32_d);
        int v_crc32_d = this.readChecksum(this.c_crc32_d);
        if (outputBufferLength == inputBufferLength) {
            this.outputBufferPos = 0;
            this.outputBufferLen.value = outputBufferLength;
            this.readBytes(this.outputBuffer, 0, outputBufferLength);
            this.testChecksum(this.c_adler32_d, v_adler32_d, this.outputBuffer, 0, outputBufferLength);
            this.testChecksum(this.c_crc32_d, v_crc32_d, this.outputBuffer, 0, outputBufferLength);
            return true;
        }
        int v_adler32_c = this.readChecksum(this.c_adler32_c);
        int v_crc32_c = this.readChecksum(this.c_crc32_c);
        this.readBytes(this.inputBuffer, 0, inputBufferLength);
        this.testChecksum(this.c_adler32_c, v_adler32_c, this.inputBuffer, 0, inputBufferLength);
        this.testChecksum(this.c_crc32_c, v_crc32_c, this.inputBuffer, 0, inputBufferLength);
        this.decompress(outputBufferLength, inputBufferLength);
        this.testChecksum(this.c_adler32_d, v_adler32_d, this.outputBuffer, 0, outputBufferLength);
        this.testChecksum(this.c_crc32_d, v_crc32_d, this.outputBuffer, 0, outputBufferLength);
        return true;
    }
}

