/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.CheckForNull;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoOutputStream;
import org.anarres.lzo.LzopConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LzopOutputStream
extends LzoOutputStream {
    private static final Log LOG = LogFactory.getLog(LzopOutputStream.class);
    private final long flags;
    private final CRC32 c_crc32_c;
    private final CRC32 c_crc32_d;
    private final Adler32 c_adler32_c;
    private final Adler32 c_adler32_d;
    private boolean closed = false;

    public LzopOutputStream(OutputStream out, LzoCompressor compressor, @CheckForSigned int inputBufferSize, long flags) throws IOException {
        super(out, compressor, inputBufferSize);
        this.flags = flags;
        this.c_crc32_c = (flags & 0x200L) == 0L ? null : new CRC32();
        this.c_crc32_d = (flags & 0x100L) == 0L ? null : new CRC32();
        this.c_adler32_c = (flags & 2L) == 0L ? null : new Adler32();
        this.c_adler32_d = (flags & 1L) == 0L ? null : new Adler32();
        this.writeLzopHeader();
    }

    public LzopOutputStream(@Nonnull OutputStream out, @Nonnull LzoCompressor compressor, @CheckForSigned int inputBufferSize) throws IOException {
        this(out, compressor, inputBufferSize, 0L);
    }

    public LzopOutputStream(@Nonnull OutputStream out, @Nonnull LzoCompressor compressor) throws IOException {
        this(out, compressor, 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLzopHeader() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dob = new DataOutputStream(bos);
        try {
            dob.writeShort(4112);
            dob.writeShort(8272);
            dob.writeShort(2368);
            switch (this.getAlgorithm()) {
                case LZO1X: {
                    LzoConstraint[] constraints = this.getConstraints();
                    if (constraints.length == 0) {
                        dob.writeByte(1);
                        dob.writeByte(5);
                        break;
                    }
                    if (constraints.length == 1 && constraints[0] == LzoConstraint.COMPRESSION) {
                        dob.writeByte(3);
                        dob.writeByte(this.getCompressor().getCompressionLevel());
                        break;
                    }
                    throw new IOException("Unsupported constraint combination for LZO1X: " + Arrays.toString((Object[])constraints));
                }
                default: {
                    throw new IOException("Incompatible lzop algorithm " + (Object)((Object)this.getAlgorithm()));
                }
            }
            long mask = 3L;
            mask = mask | 0x200L | 0x100L;
            dob.writeInt((int)(this.flags & mask & 0xFFFFFFFFFFFFFFFFL));
            dob.writeInt(33188);
            dob.writeInt((int)(System.currentTimeMillis() / 1000L));
            dob.writeInt(0);
            dob.writeByte(0);
            Adler32 headerChecksum = new Adler32();
            headerChecksum.update(bos.toByteArray());
            int hc = (int)headerChecksum.getValue();
            dob.writeInt(hc);
            this.out.write(LzopConstants.LZOP_MAGIC);
            this.out.write(bos.toByteArray());
        }
        finally {
            dob.close();
        }
    }

    private void writeChecksum(@CheckForNull Checksum csum, @Nonnull byte[] data, @Nonnegative int off, @Nonnegative int len) throws IOException {
        if (csum == null) {
            return;
        }
        csum.reset();
        csum.update(data, off, len);
        long value = csum.getValue();
        this.writeInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    protected void writeBlock(@Nonnull byte[] inputData, @Nonnegative int inputPos, @Nonnegative int inputLen, @Nonnull byte[] outputData, @Nonnegative int outputPos, @Nonnegative int outputLen) throws IOException {
        this.writeInt(inputLen);
        if (outputLen < inputLen) {
            this.writeInt(outputLen);
        } else {
            this.writeInt(inputLen);
        }
        this.writeChecksum(this.c_adler32_d, inputData, inputPos, inputLen);
        this.writeChecksum(this.c_crc32_d, inputData, inputPos, inputLen);
        if (outputLen < inputLen) {
            this.writeChecksum(this.c_adler32_c, outputData, outputPos, outputLen);
            this.writeChecksum(this.c_crc32_c, outputData, outputPos, outputLen);
        }
        if (outputLen < inputLen) {
            this.out.write(outputData, outputPos, outputLen);
        } else {
            this.out.write(inputData, inputPos, inputLen);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.out.write(new byte[]{0, 0, 0, 0});
            super.close();
            this.closed = true;
        }
    }
}

