/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import ru.yandex.kikimr.persqueue.consumer.StreamConsumer;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.stream.LogbrokerStreamConsumer;
import ru.yandex.kikimr.persqueue.consumer.stream.StreamConsumerConfig;
import ru.yandex.kikimr.persqueue.consumer.sync.LogbrokerSyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.sync.SyncConsumerConfig;
import ru.yandex.kikimr.persqueue.consumer.transport.LogbrokerConsumerTransport;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;
import ru.yandex.kikimr.persqueue.producer.async.AsyncProducerConfig;
import ru.yandex.kikimr.persqueue.producer.async.LogbrokerAsyncProducer;
import ru.yandex.kikimr.persqueue.producer.transport.LogbrokerProducerTransport;
import ru.yandex.kikimr.persqueue.proxy.ProxyBalancer;
import ru.yandex.kikimr.persqueue.proxy.ProxyConfig;

public class LogbrokerClientAsyncFactory {
    private final ProxyBalancer proxyBalancer;

    public LogbrokerClientAsyncFactory(ProxyBalancer proxyBalancer) {
        this.proxyBalancer = proxyBalancer;
    }

    public CompletableFuture<AsyncProducer> asyncProducer(AsyncProducerConfig config) {
        return this.proxyBalancer.chooseProxy().thenApply(proxyConfig -> {
            LogbrokerProducerTransport transport = new LogbrokerProducerTransport((ProxyConfig)proxyConfig, config.getCredentialsProvider());
            return new LogbrokerAsyncProducer(config, transport);
        });
    }

    public CompletableFuture<AsyncProducer> asyncProducer(String topic, byte[] sourceId) {
        return this.asyncProducer(AsyncProducerConfig.defaultConfig(topic, sourceId));
    }

    public CompletableFuture<SyncConsumer> syncConsumer(SyncConsumerConfig config) {
        return this.proxyBalancer.chooseProxy().thenApply(proxyConfig -> {
            LogbrokerConsumerTransport transport = new LogbrokerConsumerTransport((ProxyConfig)proxyConfig, config.getCredentialsProvider());
            return new LogbrokerSyncConsumer(config, transport);
        });
    }

    public CompletableFuture<SyncConsumer> syncConsumer(Collection<String> topics, String clientId) {
        return this.syncConsumer(SyncConsumerConfig.defaultConfig(topics, clientId));
    }

    public CompletableFuture<StreamConsumer> streamConsumer(StreamConsumerConfig config) {
        return this.proxyBalancer.chooseProxy().thenApply(proxyConfig -> {
            LogbrokerConsumerTransport transport = new LogbrokerConsumerTransport((ProxyConfig)proxyConfig, config.getCredentialsProvider());
            return new LogbrokerStreamConsumer(config, transport);
        });
    }

    public CompletableFuture<StreamConsumer> streamConsumer(Collection<String> topics, String clientId) {
        return this.streamConsumer(StreamConsumerConfig.defaultConfig(topics, clientId));
    }
}

