/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ru.yandex.kikimr.persqueue.LogbrokerClientAsyncFactory;
import ru.yandex.kikimr.persqueue.consumer.StreamConsumer;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.kikimr.persqueue.consumer.stream.StreamConsumerConfig;
import ru.yandex.kikimr.persqueue.consumer.sync.SyncConsumerConfig;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;
import ru.yandex.kikimr.persqueue.producer.async.AsyncProducerConfig;
import ru.yandex.kikimr.persqueue.proxy.ProxyBalancer;

public class LogbrokerClientFactory {
    private final LogbrokerClientAsyncFactory asyncFactory;

    public LogbrokerClientFactory(ProxyBalancer proxyBalancer) {
        this.asyncFactory = new LogbrokerClientAsyncFactory(proxyBalancer);
    }

    public AsyncProducer asyncProducer(AsyncProducerConfig config) throws InterruptedException {
        try {
            return this.asyncFactory.asyncProducer(config).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public AsyncProducer asyncProducer(String topic, byte[] sourceId) throws InterruptedException {
        return this.asyncProducer(AsyncProducerConfig.defaultConfig(topic, sourceId));
    }

    public SyncConsumer syncConsumer(SyncConsumerConfig config) throws InterruptedException {
        try {
            return this.asyncFactory.syncConsumer(config).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public SyncConsumer syncConsumer(SyncConsumerConfig config, long timeout, TimeUnit timeoutUnit) throws InterruptedException, TimeoutException {
        try {
            return this.asyncFactory.syncConsumer(config).get(timeout, timeoutUnit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public SyncConsumer syncConsumer(Collection<String> topics, String clientId) throws InterruptedException {
        return this.syncConsumer(SyncConsumerConfig.defaultConfig(topics, clientId));
    }

    public StreamConsumer streamConsumer(StreamConsumerConfig config) throws InterruptedException {
        try {
            return this.asyncFactory.streamConsumer(config).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public StreamConsumer streamConsumer(Collection<String> topics, String clientId) throws InterruptedException {
        return this.streamConsumer(StreamConsumerConfig.defaultConfig(topics, clientId));
    }
}

