/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.auth;

import java.util.Objects;
import java.util.function.Supplier;

public class Credentials {
    public static final Supplier<Credentials> NONE_PROVIDER = Credentials::none;
    private final CredentialsType type;
    private final String value;

    private Credentials(CredentialsType type, String value) {
        this.type = type;
        this.value = value;
    }

    public static Credentials none() {
        return new Credentials(CredentialsType.NONE, "");
    }

    public static Credentials oauth(String token) {
        return new Credentials(CredentialsType.OAUTH, token);
    }

    public static Credentials tvm(String ticket) {
        return new Credentials(CredentialsType.TVM, ticket);
    }

    public CredentialsType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        return this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public static enum CredentialsType {
        NONE,
        OAUTH,
        TVM;

    }
}

