/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.compression;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.LzopInputStream;
import org.anarres.lzo.LzopOutputStream;
import ru.yandex.kikimr.persqueue.compression.UnsupportedCodecException;
import ru.yandex.ydb.persqueue.Persqueue;

public enum CompressionCodec {
    RAW(Persqueue.ECodec.RAW),
    GZIP(Persqueue.ECodec.GZIP),
    LZOP(Persqueue.ECodec.LZOP);

    private final Persqueue.ECodec eCodec;

    private CompressionCodec(Persqueue.ECodec eCodec) {
        this.eCodec = eCodec;
    }

    public static CompressionCodec fromECodec(Persqueue.ECodec eCodec) {
        return Arrays.stream(CompressionCodec.values()).filter(compressionCodec -> compressionCodec.eCodec == eCodec).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown compression: " + eCodec));
    }

    public Persqueue.ECodec toECodec() {
        return this.eCodec;
    }

    public byte[] compressData(byte[] data) {
        byte[] result;
        switch (this) {
            case RAW: {
                result = data;
                break;
            }
            case GZIP: {
                ByteArrayOutputStream gzipBuffer = new ByteArrayOutputStream();
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(gzipBuffer);){
                    gzipOutputStream.write(data);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                result = gzipBuffer.toByteArray();
                break;
            }
            case LZOP: {
                ByteArrayOutputStream lzopBuffer = new ByteArrayOutputStream();
                LzoCompressor compressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
                try (LzopOutputStream lzopOutputStream = new LzopOutputStream((OutputStream)lzopBuffer, compressor);){
                    lzopOutputStream.write(data);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                result = lzopBuffer.toByteArray();
                break;
            }
            default: {
                throw new UnsupportedCodecException(this);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] decompressData(byte[] data) {
        switch (1.$SwitchMap$ru$yandex$kikimr$persqueue$compression$CompressionCodec[this.ordinal()]) {
            case 1: {
                result = data;
                break;
            }
            case 2: {
                gzipStream = new ByteArrayInputStream(data);
                try {
                    gzipInputStream = new GZIPInputStream(gzipStream);
                    var5_7 = null;
                    result = ByteStreams.toByteArray((InputStream)gzipInputStream);
                    if (gzipInputStream == null) break;
                    if (var5_7 == null) ** GOTO lbl20
                    try {
                        gzipInputStream.close();
                    }
                    catch (Throwable var6_10) {
                        var5_7.addSuppressed(var6_10);
                    }
                    break;
lbl20:
                    // 1 sources

                    gzipInputStream.close();
                    ** break;
                    catch (Throwable var6_11) {
                        try {
                            var5_7 = var6_11;
                            throw var6_11;
                        }
                        catch (Throwable var7_13) {
                            if (gzipInputStream != null) {
                                if (var5_7 != null) {
                                    try {
                                        gzipInputStream.close();
                                    }
                                    catch (Throwable var8_16) {
                                        var5_7.addSuppressed(var8_16);
                                    }
                                } else {
                                    gzipInputStream.close();
                                }
                            }
                            throw var7_13;
lbl37:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 3: {
                lzopStream = new ByteArrayInputStream(data);
                try {
                    lzopInputStream = new LzopInputStream((InputStream)lzopStream);
                    var6_12 = null;
                    result = ByteStreams.toByteArray((InputStream)lzopInputStream);
                    if (lzopInputStream == null) break;
                    if (var6_12 == null) ** GOTO lbl55
                    try {
                        lzopInputStream.close();
                    }
                    catch (Throwable var7_14) {
                        var6_12.addSuppressed(var7_14);
                    }
                    break;
lbl55:
                    // 1 sources

                    lzopInputStream.close();
                    ** break;
                    catch (Throwable var7_15) {
                        try {
                            var6_12 = var7_15;
                            throw var7_15;
                        }
                        catch (Throwable var9_17) {
                            if (lzopInputStream != null) {
                                if (var6_12 != null) {
                                    try {
                                        lzopInputStream.close();
                                    }
                                    catch (Throwable var10_18) {
                                        var6_12.addSuppressed(var10_18);
                                    }
                                } else {
                                    lzopInputStream.close();
                                }
                            }
                            throw var9_17;
lbl72:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new UnsupportedCodecException(this);
            }
        }
        return result;
    }
}

