/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConsumerSessionConfig {
    private final Collection<String> topics;
    private final boolean readOnlyLocal;
    private final Collection<String> dataCenters;
    private final String clientId;
    private final boolean clientSideLocksAllowed;
    private final boolean forceBalancePartitions;
    private final List<Integer> groups;
    private final int idleTimeoutSec;

    private ConsumerSessionConfig(Builder builder) {
        this.topics = builder.topics;
        this.readOnlyLocal = builder.readOnlyLocal;
        this.dataCenters = builder.dataCenters;
        this.clientId = builder.clientId;
        this.clientSideLocksAllowed = builder.clientSideLocksAllowed;
        this.forceBalancePartitions = builder.forceBalancePartitions;
        this.groups = builder.groups;
        this.idleTimeoutSec = builder.idleTimeoutSec;
    }

    public Collection<String> getTopics() {
        return this.topics;
    }

    public boolean isReadOnlyLocal() {
        return this.readOnlyLocal;
    }

    public Collection<String> getDataCenters() {
        return this.dataCenters;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isClientSideLocksAllowed() {
        return this.clientSideLocksAllowed;
    }

    public boolean isForceBalancePartitions() {
        return this.forceBalancePartitions;
    }

    public List<Integer> getGroups() {
        return this.groups;
    }

    public int getIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    public static Builder builder(Collection<String> topics, String clientId) {
        return new Builder(topics, clientId);
    }

    public static ConsumerSessionConfig defaultConfig(Collection<String> topics, String clientId) {
        return new Builder(topics, clientId).build();
    }

    public static class Builder {
        private final Collection<String> topics;
        private final String clientId;
        private Collection<String> dataCenters = new ArrayList<String>();
        private boolean readOnlyLocal = false;
        private boolean clientSideLocksAllowed = false;
        private boolean forceBalancePartitions = false;
        private List<Integer> groups = new ArrayList<Integer>();
        private int idleTimeoutSec = (int)TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS);

        Builder(Collection<String> topics, String clientId) {
            this.topics = topics;
            this.clientId = clientId;
        }

        public Builder setDataCenters(Collection<String> dataCenters) {
            this.dataCenters = new ArrayList<String>(dataCenters);
            return this;
        }

        public Builder addDataCenter(String dataCenter) {
            this.dataCenters.add(dataCenter);
            return this;
        }

        public Builder setReadOnlyLocal(boolean readOnlyLocal) {
            this.readOnlyLocal = readOnlyLocal;
            return this;
        }

        public Builder setClientSideLocksAllowed(boolean clientSideLocksAllowed) {
            this.clientSideLocksAllowed = clientSideLocksAllowed;
            return this;
        }

        public Builder setForceBalancePartitions(boolean forceBalancePartitions) {
            this.forceBalancePartitions = forceBalancePartitions;
            return this;
        }

        public Builder setGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setIdleTimeoutSec(int idleTimeoutSec) {
            this.idleTimeoutSec = idleTimeoutSec;
            return this;
        }

        public ConsumerSessionConfig build() {
            return new ConsumerSessionConfig(this);
        }
    }
}

