/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.consumer.internal.read;

public class ReaderConfig {
    private final int maxCount;
    private final int maxSize;
    private final int partitionsAtOnce;
    private final int maxTimeLagMs;
    private final int maxInflightReads;
    private final int maxUnconsumedReads;

    private ReaderConfig(Builder builder) {
        this.maxCount = builder.maxCount;
        this.maxSize = builder.maxSize;
        this.partitionsAtOnce = builder.partitionsAtOnce;
        this.maxTimeLagMs = builder.maxTimeLagMs;
        this.maxInflightReads = builder.maxInflightReads;
        this.maxUnconsumedReads = builder.maxUnconsumedReads;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPartitionsAtOnce() {
        return this.partitionsAtOnce;
    }

    public int getMaxTimeLagMs() {
        return this.maxTimeLagMs;
    }

    public int getMaxInflightReads() {
        return this.maxInflightReads;
    }

    public int getMaxUnconsumedReads() {
        return this.maxUnconsumedReads;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReaderConfig defaultSettings() {
        return ReaderConfig.builder().build();
    }

    public static class Builder {
        private int maxCount = 10;
        private int maxSize = Integer.MAX_VALUE;
        private int partitionsAtOnce = 0;
        private int maxTimeLagMs = Integer.MAX_VALUE;
        private int maxInflightReads = 10;
        private int maxUnconsumedReads = 1000;

        public Builder setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder setPartitionsAtOnce(int partitionsAtOnce) {
            this.partitionsAtOnce = partitionsAtOnce;
            return this;
        }

        public Builder setMaxTimeLagMs(int maxTimeLagMs) {
            this.maxTimeLagMs = maxTimeLagMs;
            return this;
        }

        public Builder setMaxUnconsumedReads(int maxUnconsumedReads) {
            this.maxUnconsumedReads = maxUnconsumedReads;
            return this;
        }

        public ReaderConfig build() {
            return new ReaderConfig(this);
        }
    }
}

