/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.consumer.stream;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.yandex.kikimr.persqueue.auth.Credentials;
import ru.yandex.kikimr.persqueue.consumer.ConsumerSessionConfig;
import ru.yandex.kikimr.persqueue.consumer.internal.commit.CommitterConfig;
import ru.yandex.kikimr.persqueue.consumer.internal.read.ReaderConfig;

public class StreamConsumerConfig {
    private final ReaderConfig readerConfig;
    private final CommitterConfig committerConfig;
    private final ConsumerSessionConfig sessionConfig;
    private final ExecutorService executor;
    private final Supplier<Credentials> credentialsProvider;

    private StreamConsumerConfig(Builder builder) {
        this.readerConfig = builder.readerConfigBuilder.build();
        this.committerConfig = builder.committerConfigBuilder.build();
        this.sessionConfig = builder.sessionConfigBuilder.build();
        this.executor = builder.executor;
        this.credentialsProvider = builder.credentialsProvider;
    }

    public ReaderConfig getReaderConfig() {
        return this.readerConfig;
    }

    public CommitterConfig getCommitterConfig() {
        return this.committerConfig;
    }

    public ConsumerSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Supplier<Credentials> getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public static Builder builder(Collection<String> topics, String clientId) {
        return new Builder(topics, clientId);
    }

    public static StreamConsumerConfig defaultConfig(Collection<String> topics, String clientId) {
        return StreamConsumerConfig.builder(topics, clientId).build();
    }

    public static class Builder {
        private ReaderConfig.Builder readerConfigBuilder = ReaderConfig.builder();
        private CommitterConfig.Builder committerConfigBuilder = CommitterConfig.builder();
        private ConsumerSessionConfig.Builder sessionConfigBuilder;
        private ExecutorService executor = null;
        private Supplier<Credentials> credentialsProvider = Credentials.NONE_PROVIDER;

        private Builder(Collection<String> topics, String clientId) {
            this.sessionConfigBuilder = ConsumerSessionConfig.builder(topics, clientId);
        }

        public Builder configureReader(Consumer<ReaderConfig.Builder> configurator) {
            configurator.accept(this.readerConfigBuilder);
            return this;
        }

        public Builder configureCommiter(Consumer<CommitterConfig.Builder> configurator) {
            configurator.accept(this.committerConfigBuilder);
            return this;
        }

        public Builder configureSession(Consumer<ConsumerSessionConfig.Builder> configurator) {
            configurator.accept(this.sessionConfigBuilder);
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setCredentialsProvider(Supplier<Credentials> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public StreamConsumerConfig build() {
            if (this.executor == null) {
                this.executor = MoreExecutors.newDirectExecutorService();
            }
            return new StreamConsumerConfig(this);
        }
    }
}

