/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.consumer.sync;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ru.yandex.kikimr.persqueue.auth.Credentials;
import ru.yandex.kikimr.persqueue.consumer.ConsumerSessionConfig;
import ru.yandex.kikimr.persqueue.consumer.internal.commit.CommitterConfig;
import ru.yandex.kikimr.persqueue.consumer.internal.read.ReaderConfig;

public class SyncConsumerConfig {
    private final ReaderConfig readerConfig;
    private final CommitterConfig committerConfig;
    private final ConsumerSessionConfig sessionConfig;
    private final int readBufferSize;
    private final int readDataTimeout;
    private final TimeUnit readDataTimeoutUnit;
    private final int initTimeout;
    private final TimeUnit initTimeoutUnit;
    private final Supplier<Credentials> credentialsProvider;
    private final int commitTimeout;
    private final TimeUnit commitTimeoutUnit;

    private SyncConsumerConfig(Builder builder) {
        this.readerConfig = builder.readerConfigBuilder.build();
        this.committerConfig = builder.committerConfigBuilder.build();
        this.sessionConfig = builder.sessionConfigBuilder.build();
        this.readBufferSize = builder.readBufferSize;
        this.readDataTimeout = builder.readDataTimeout;
        this.readDataTimeoutUnit = builder.readDataTimeoutUnit;
        this.initTimeout = builder.initTimeout;
        this.initTimeoutUnit = builder.initTimeoutUnit;
        this.commitTimeout = builder.commitTimeout;
        this.commitTimeoutUnit = builder.commitTimeoutUnit;
        this.credentialsProvider = builder.credentialsProvider;
    }

    public ReaderConfig getReaderConfig() {
        return this.readerConfig;
    }

    public CommitterConfig getCommitterConfig() {
        return this.committerConfig;
    }

    public ConsumerSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getReadDataTimeout() {
        return this.readDataTimeout;
    }

    public TimeUnit getReadDataTimeoutUnit() {
        return this.readDataTimeoutUnit;
    }

    public int getCommitTimeout() {
        return this.commitTimeout;
    }

    public TimeUnit getCommitTimeoutUnit() {
        return this.commitTimeoutUnit;
    }

    public int getInitTimeout() {
        return this.initTimeout;
    }

    public TimeUnit getInitTimeoutUnit() {
        return this.initTimeoutUnit;
    }

    public Supplier<Credentials> getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public static Builder builder(Collection<String> topics, String clientId) {
        return new Builder(topics, clientId);
    }

    public static SyncConsumerConfig defaultConfig(Collection<String> topics, String clientId) {
        return SyncConsumerConfig.builder(topics, clientId).build();
    }

    public static class Builder {
        private ReaderConfig.Builder readerConfigBuilder = ReaderConfig.builder();
        private CommitterConfig.Builder committerConfigBuilder = CommitterConfig.builder();
        private ConsumerSessionConfig.Builder sessionConfigBuilder;
        private int readBufferSize = 1000;
        private int readDataTimeout = 1;
        private TimeUnit readDataTimeoutUnit = TimeUnit.HOURS;
        private int initTimeout = 10;
        private TimeUnit initTimeoutUnit = TimeUnit.MINUTES;
        private int commitTimeout = 10;
        private TimeUnit commitTimeoutUnit = TimeUnit.MINUTES;
        private Supplier<Credentials> credentialsProvider = Credentials.NONE_PROVIDER;

        private Builder(Collection<String> topics, String clientId) {
            this.sessionConfigBuilder = ConsumerSessionConfig.builder(topics, clientId);
        }

        public Builder configureReader(Consumer<ReaderConfig.Builder> configurator) {
            configurator.accept(this.readerConfigBuilder);
            return this;
        }

        public Builder configureCommiter(Consumer<CommitterConfig.Builder> configurator) {
            configurator.accept(this.committerConfigBuilder);
            return this;
        }

        public Builder configureSession(Consumer<ConsumerSessionConfig.Builder> configurator) {
            configurator.accept(this.sessionConfigBuilder);
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            this.readerConfigBuilder.setMaxUnconsumedReads(readBufferSize);
            return this;
        }

        public Builder setReadDataTimeout(int readDataTimeout, TimeUnit readDataTimeoutUnit) {
            this.readDataTimeout = readDataTimeout;
            this.readDataTimeoutUnit = readDataTimeoutUnit;
            return this;
        }

        public Builder setInitTimeout(int initTimeout, TimeUnit initTimeoutUnit) {
            this.initTimeout = initTimeout;
            this.initTimeoutUnit = initTimeoutUnit;
            return this;
        }

        public Builder setCommitTimeout(int commitTimeout, TimeUnit commitTimeoutUnit) {
            this.commitTimeout = commitTimeout;
            this.commitTimeoutUnit = commitTimeoutUnit;
            return this;
        }

        public Builder setCredentialsProvider(Supplier<Credentials> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public SyncConsumerConfig build() {
            return new SyncConsumerConfig(this);
        }
    }
}

