/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.producer.async;

import java.util.function.Supplier;
import ru.yandex.kikimr.persqueue.auth.Credentials;
import ru.yandex.kikimr.persqueue.compression.CompressionCodec;

public class AsyncProducerConfig {
    private final String topic;
    private final byte[] sourceId;
    private final CompressionCodec codec;
    private final int group;
    private final Supplier<Credentials> credentialsProvider;

    private AsyncProducerConfig(Builder builder) {
        this.topic = builder.topic;
        this.sourceId = builder.sourceId;
        this.codec = builder.codec;
        this.group = builder.group;
        this.credentialsProvider = builder.credentialsProvider;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getSourceId() {
        return this.sourceId;
    }

    public CompressionCodec getCodec() {
        return this.codec;
    }

    public int getGroup() {
        return this.group;
    }

    public Supplier<Credentials> getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public static Builder builder(String topic, byte[] sourceId) {
        return new Builder(topic, sourceId);
    }

    public static AsyncProducerConfig defaultConfig(String topic, byte[] sourceId) {
        return new Builder(topic, sourceId).build();
    }

    public static class Builder {
        private String topic;
        private byte[] sourceId;
        private CompressionCodec codec = CompressionCodec.RAW;
        private int group = 0;
        private Supplier<Credentials> credentialsProvider = Credentials.NONE_PROVIDER;

        Builder(String topic, byte[] sourceId) {
            this.topic = topic;
            this.sourceId = sourceId;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setSourceId(byte[] sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder setCodec(CompressionCodec codec) {
            this.codec = codec;
            return this;
        }

        public Builder setGroup(int group) {
            this.group = group;
            return this;
        }

        public Builder setCredentialsProvider(Supplier<Credentials> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public AsyncProducerConfig build() {
            return new AsyncProducerConfig(this);
        }
    }
}

