/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.kikimr.persqueue.proxy;

import NKikimrClient.TGRpcServerGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import ru.yandex.kikimr.persqueue.proxy.ProxyConfig;
import ru.yandex.kikimr.proto.Msgbus;

public class ProxyBalancer {
    private static final int DEFAULT_BALANCER_PORT = 2135;
    private static final int DEFAULT_PROXY_PORT = 2135;
    private final int proxyPort;
    private final ManagedChannel balancerChannel;
    private final TGRpcServerGrpc.TGRpcServerStub balancerServerStub;

    public ProxyBalancer(String balancerHost) {
        this(balancerHost, 2135, 2135);
    }

    public ProxyBalancer(String balancerHost, int balancerPort) {
        this(balancerHost, balancerPort, 2135);
    }

    public ProxyBalancer(String balancerHost, int balancerPort, int proxyPort) {
        this.proxyPort = proxyPort;
        this.balancerChannel = ManagedChannelBuilder.forAddress((String)balancerHost, (int)balancerPort).usePlaintext().build();
        this.balancerServerStub = TGRpcServerGrpc.newStub((Channel)this.balancerChannel);
    }

    public CompletableFuture<ProxyConfig> chooseProxy() {
        final CompletableFuture<ProxyConfig> resultFuture = new CompletableFuture<ProxyConfig>();
        this.balancerServerStub.chooseProxy(Msgbus.TChooseProxyRequest.getDefaultInstance(), (StreamObserver)new StreamObserver<Msgbus.TResponse>(){

            public void onNext(Msgbus.TResponse value) {
                long proxyCookie = value.getProxyCookie();
                String proxyHost = value.getProxyName();
                resultFuture.complete(new ProxyConfig(proxyHost, ProxyBalancer.this.proxyPort, proxyCookie));
            }

            public void onError(Throwable t) {
                resultFuture.completeExceptionally(t);
            }

            public void onCompleted() {
                if (!resultFuture.isDone()) {
                    resultFuture.completeExceptionally(new IllegalStateException("Proxy request channel closed without result or error"));
                }
            }
        });
        return resultFuture;
    }

    public boolean shutdown(int timeout, TimeUnit unit) throws InterruptedException {
        return this.balancerChannel.shutdown().awaitTermination((long)timeout, unit);
    }
}

