/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.MpmcArrayQueueConsumerField;
import org.jctools.queues.QueueProgressIndicators;

public class MpmcArrayQueue<E>
extends MpmcArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    long p40;
    long p41;
    long p42;
    long p43;
    long p44;
    long p45;
    long p46;
    long p30;
    long p31;
    long p32;
    long p33;
    long p34;
    long p35;
    long p36;
    long p37;

    public MpmcArrayQueue(int capacity) {
        super(MpmcArrayQueue.validateCapacity(capacity));
    }

    private static int validateCapacity(int capacity) {
        if (capacity < 2) {
            throw new IllegalArgumentException("Minimum size is 2");
        }
        return capacity;
    }

    @Override
    public boolean offer(E e) {
        long currentProducerIndex;
        long seqOffset;
        long[] sBuffer;
        long mask;
        block3: {
            if (null == e) {
                throw new NullPointerException("Null is not a valid element");
            }
            mask = this.mask;
            long capacity = mask + 1L;
            sBuffer = this.sequenceBuffer;
            long cIndex = Long.MAX_VALUE;
            while (true) {
                long seq;
                long delta;
                if ((delta = (seq = this.lvSequence(sBuffer, seqOffset = MpmcArrayQueue.calcSequenceOffset(currentProducerIndex = this.lvProducerIndex(), mask))) - currentProducerIndex) == 0L) {
                    if (!this.casProducerIndex(currentProducerIndex, currentProducerIndex + 1L)) continue;
                    break block3;
                }
                if (delta < 0L && currentProducerIndex - capacity <= cIndex && currentProducerIndex - capacity <= (cIndex = this.lvConsumerIndex())) break;
            }
            return false;
        }
        long elementOffset = MpmcArrayQueue.calcElementOffset(currentProducerIndex, mask);
        this.spElement(elementOffset, e);
        this.soSequence(sBuffer, seqOffset, currentProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long seqOffset;
        long mask;
        long[] lSequenceBuffer;
        block2: {
            lSequenceBuffer = this.sequenceBuffer;
            mask = this.mask;
            long pIndex = -1L;
            while (true) {
                long seq;
                long delta;
                if ((delta = (seq = this.lvSequence(lSequenceBuffer, seqOffset = MpmcArrayQueue.calcSequenceOffset(currentConsumerIndex = this.lvConsumerIndex(), mask))) - (currentConsumerIndex + 1L)) == 0L) {
                    if (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L)) continue;
                    break block2;
                }
                if (delta < 0L && currentConsumerIndex >= pIndex && currentConsumerIndex == (pIndex = this.lvProducerIndex())) break;
            }
            return null;
        }
        long offset = MpmcArrayQueue.calcElementOffset(currentConsumerIndex, mask);
        Object e = this.lpElement(offset);
        this.spElement(offset, null);
        this.soSequence(lSequenceBuffer, seqOffset, currentConsumerIndex + mask + 1L);
        return e;
    }

    @Override
    public E peek() {
        long currConsumerIndex;
        Object e;
        while ((e = this.lpElement(this.calcElementOffset(currConsumerIndex = this.lvConsumerIndex()))) == null && currConsumerIndex != this.lvProducerIndex()) {
        }
        return e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

