/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.SpmcArrayQueueL3Pad;

public class SpmcArrayQueue<E>
extends SpmcArrayQueueL3Pad<E>
implements QueueProgressIndicators {
    public SpmcArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        long offset = SpmcArrayQueue.calcElementOffset(currProducerIndex, mask);
        if (null != this.lvElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > mask) {
                return false;
            }
            while (null != this.lvElement(buffer, offset)) {
            }
        }
        this.spElement(buffer, offset, e);
        this.soTail(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casHead(currentConsumerIndex, currentConsumerIndex + 1L));
        long offset = this.calcElementOffset(currentConsumerIndex);
        Object[] lb = this.buffer;
        Object e = this.lpElement(lb, offset);
        this.soElement(lb, offset, null);
        return (E)e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        long mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (null == (e = this.lvElement(SpmcArrayQueue.calcElementOffset(currentConsumerIndex, mask))));
        return e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

