/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.SpscArrayQueueL3Pad;
import org.jctools.util.UnsafeAccess;

public class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E>
implements QueueProgressIndicators {
    public SpscArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long index = this.producerIndex;
        long offset = SpscArrayQueue.calcElementOffset(index, mask);
        if (index >= this.producerLookAhead) {
            int step = this.lookAheadStep;
            if (null == this.lvElement(buffer, SpscArrayQueue.calcElementOffset(index + (long)step, mask))) {
                this.producerLookAhead = index + (long)step;
            } else if (null != this.lvElement(buffer, offset)) {
                return false;
            }
        }
        this.soProducerIndex(index + 1L);
        this.soElement(buffer, offset, e);
        return true;
    }

    @Override
    public E poll() {
        Object[] lElementBuffer = this.buffer;
        long index = this.consumerIndex;
        long offset = this.calcElementOffset(index);
        Object e = this.lvElement(lElementBuffer, offset);
        if (null == e) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        this.soElement(lElementBuffer, offset, null);
        return (E)e;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }
}

