/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.SpscGrowableArrayQueueConsumerField;
import org.jctools.queues.SpscGrowableArrayQueueProducerFields;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeAccess;

public class SpscGrowableArrayQueue<E>
extends SpscGrowableArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    private static final int MAX_LOOK_AHEAD_STEP;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;

    public SpscGrowableArrayQueue(int maxCapacity) {
        this(Math.min(Pow2.roundToPowerOfTwo(maxCapacity / 2), 16), maxCapacity);
    }

    public SpscGrowableArrayQueue(int initialCapacity, int maxCapacity) {
        if (initialCapacity >= maxCapacity) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity");
        }
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1;
        Object[] buffer = new Object[p2capacity];
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2capacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(maxCapacity);
        this.producerLookAhead = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.producerBuffer;
        long index = this.producerIndex;
        long mask = this.producerMask;
        long offset = SpscGrowableArrayQueue.calcElementOffset(index, mask);
        if (index < this.producerLookAhead) {
            this.writeToQueue(buffer, e, index, offset);
            return true;
        }
        int lookAheadStep = this.producerLookAheadStep;
        if (lookAheadStep > 0) {
            long lookAheadElementOffset = SpscGrowableArrayQueue.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == SpscGrowableArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
                this.producerLookAhead = index + (long)lookAheadStep - 1L;
                this.writeToQueue(buffer, e, index, offset);
                return true;
            }
            int maxCapacity = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity) {
                if (null == SpscGrowableArrayQueue.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e, index, offset);
                    return true;
                }
                return false;
            }
            if (null == SpscGrowableArrayQueue.lvElement(buffer, SpscGrowableArrayQueue.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, e, index, offset);
            } else {
                this.resize(buffer, index, offset, maxCapacity, e);
            }
            return true;
        }
        return this.offerWhileWaitingForConsumerOnLastBuffer(buffer, e, index, mask, offset, lookAheadStep);
    }

    private boolean offerWhileWaitingForConsumerOnLastBuffer(E[] buffer, E e, long index, long mask, long offset, int lookAheadStep) {
        int maxCapacity;
        int prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerLookAhead - (long)maxCapacity + (long)prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.producerLookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerLookAhead = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e, index, offset);
        return true;
    }

    private void writeToQueue(E[] buffer, E e, long index, long offset) {
        this.soProducerIndex(index + 1L);
        SpscGrowableArrayQueue.soElement(buffer, offset, e);
    }

    private void resize(E[] old, long currIndex, long offset, int maxCapacity, E e) {
        long newMask;
        int newCapacity = 2 * old.length;
        Object[] newBuffer = new Object[newCapacity];
        this.producerBuffer = newBuffer;
        this.producerMask = newMask = (long)(newCapacity - 1);
        if (newCapacity == maxCapacity) {
            long currConsumerIndex = this.lvConsumerIndex();
            this.producerLookAheadStep = -((int)(currIndex - currConsumerIndex));
            this.producerLookAhead = currConsumerIndex + (long)maxCapacity - 1L;
        } else {
            this.producerLookAhead = currIndex + this.producerMask - 1L;
            this.adjustLookAheadStep(newCapacity);
        }
        long offsetInNew = SpscGrowableArrayQueue.calcElementOffset(currIndex, newMask);
        this.soProducerIndex(currIndex + 1L);
        SpscGrowableArrayQueue.soElement(newBuffer, offsetInNew, e);
        SpscGrowableArrayQueue.soElement(old, offset, new NextHolder(newBuffer));
    }

    @Override
    public final E poll() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long offset = SpscGrowableArrayQueue.calcElementOffset(index, this.consumerMask);
        Object e = SpscGrowableArrayQueue.lvElement(buffer, offset);
        boolean isNextBuffer = e instanceof NextHolder;
        if (null != e && !isNextBuffer) {
            this.soConsumerIndex(index + 1L);
            SpscGrowableArrayQueue.soElement(buffer, offset, null);
            return (E)e;
        }
        if (isNextBuffer) {
            return (E)this.newBufferPoll(((NextHolder)e).next, index);
        }
        return null;
    }

    private E newBufferPoll(E[] nextBuffer, long index) {
        long newMask;
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 1);
        long offsetInNew = SpscGrowableArrayQueue.calcElementOffset(index, newMask);
        Object n = SpscGrowableArrayQueue.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        SpscGrowableArrayQueue.soElement(nextBuffer, offsetInNew, null);
        return (E)n;
    }

    @Override
    public final E peek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long offset = SpscGrowableArrayQueue.calcElementOffset(index, this.consumerMask);
        Object e = SpscGrowableArrayQueue.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        if (e instanceof NextHolder) {
            return (E)this.newBufferPeek(((NextHolder)e).next, index);
        }
        return (E)e;
    }

    private E newBufferPeek(E[] nextBuffer, long index) {
        long newMask;
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 1);
        long offsetInNew = SpscGrowableArrayQueue.calcElementOffset(index, newMask);
        return (E)SpscGrowableArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private static final long calcElementOffset(long index, long mask) {
        return REF_ARRAY_BASE + ((index & mask) << REF_ELEMENT_SHIFT);
    }

    private static final void soElement(Object[] buffer, long offset, Object e) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
    }

    private static final <E> Object lvElement(E[] buffer, long offset) {
        return UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    static {
        Field iField;
        MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
        try {
            iField = SpscGrowableArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            iField = SpscGrowableArrayQueueConsumerField.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NextHolder {
        final Object[] next;

        public NextHolder(Object[] next) {
            this.next = next;
        }
    }
}

