/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.sets;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeAccess;

public class OpenHashSet<E>
extends AbstractSet<E> {
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;
    private static final Object TOMBSTONE;
    private int occupancy;
    private int size;
    private int mask;
    private E[] buffer;
    private int resizeThreshold;

    public OpenHashSet(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = new Object[actualCapacity];
        this.resizeThreshold = (int)(0.75 * (double)actualCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E newVal) {
        if (newVal == null) {
            throw new IllegalArgumentException();
        }
        int hash = this.calcHash(newVal);
        long offset = this.calcOffset(hash);
        E e = this.lpElement(offset);
        if (this.replaceElement(e, newVal, offset)) {
            return true;
        }
        if (e.equals(newVal)) {
            return false;
        }
        return this.addSlowPath(newVal, hash);
    }

    protected int calcHash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    private boolean addSlowPath(E newVal, int hash) {
        for (int i = hash + 1; i <= hash + this.mask; ++i) {
            long offset = this.calcOffset(i);
            E e = this.lpElement(offset);
            if (this.replaceElement(e, newVal, offset)) {
                return true;
            }
            if (!e.equals(newVal)) continue;
            return false;
        }
        return false;
    }

    private boolean replaceElement(E oldVal, E newVal, long offset) {
        if (oldVal == null) {
            ++this.occupancy;
        } else if (oldVal != TOMBSTONE) {
            return false;
        }
        this.spElement(offset, newVal);
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.resize();
        }
        return true;
    }

    private void resize() {
        E[] oldBuffer = this.buffer;
        int newCapacity = oldBuffer.length * 2;
        this.buffer = new Object[newCapacity];
        this.mask = this.buffer.length - 1;
        this.resizeThreshold = (int)(0.75 * (double)newCapacity);
        int countdown = this.size;
        this.size = 0;
        this.occupancy = 0;
        for (int i = 0; i < oldBuffer.length && countdown > 0; ++i) {
            if (oldBuffer[i] == null || oldBuffer[i] == TOMBSTONE) continue;
            this.add(oldBuffer[i]);
            --countdown;
        }
    }

    @Override
    public boolean remove(Object val) {
        if (val == null) {
            return false;
        }
        int hash = this.calcHash(val);
        long offset = this.calcOffset(hash);
        E e = this.lpElement(offset);
        if (e == null) {
            return false;
        }
        if (e.equals(val)) {
            if (this.lpElement(this.calcOffset(hash + 1)) == null) {
                this.spElement(offset, null);
                while (this.lpElement(offset = this.calcOffset(--hash)) == TOMBSTONE) {
                    this.spElement(offset, null);
                }
            } else {
                this.spElement(offset, TOMBSTONE);
            }
            --this.size;
            return true;
        }
        for (int i = hash + 1; i <= hash + this.mask; ++i) {
            offset = this.calcOffset(i);
            e = this.lpElement(offset);
            if (e == null) {
                return false;
            }
            if (!e.equals(val)) continue;
            this.spElement(offset, TOMBSTONE);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object val) {
        if (val == null) {
            return false;
        }
        int hash = this.calcHash(val);
        long offset = this.calcOffset(hash);
        E e = this.lpElement(offset);
        if (e == null) {
            return false;
        }
        if (e.equals(val)) {
            return true;
        }
        for (int i = hash + 1; i <= hash + this.mask; ++i) {
            offset = this.calcOffset(i);
            e = this.lpElement(offset);
            if (e == null) {
                return false;
            }
            if (!e.equals(val)) continue;
            return true;
        }
        return false;
    }

    private long calcOffset(long index) {
        return REF_ARRAY_BASE + ((index & (long)this.mask) << REF_ELEMENT_SHIFT);
    }

    private void spElement(long offset, Object e) {
        UnsafeAccess.UNSAFE.putObject(this.buffer, offset, e);
    }

    protected final E lpElement(long offset) {
        return (E)UnsafeAccess.UNSAFE.getObject(this.buffer, offset);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(this);
    }

    static {
        TOMBSTONE = new Object();
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    }

    private static final class Iter<E>
    implements Iterator<E> {
        private final E[] buffer;
        private final OpenHashSet<E> set;
        private int index;
        private E nextVal = null;
        private E lastVal = null;

        public Iter(OpenHashSet<E> set) {
            this.set = set;
            this.buffer = ((OpenHashSet)set).buffer;
            this.findNextVal();
        }

        @Override
        public boolean hasNext() {
            return this.nextVal != null;
        }

        @Override
        public E next() {
            if (this.nextVal == null) {
                throw new NoSuchElementException();
            }
            E e = this.nextVal;
            this.findNextVal();
            this.lastVal = e;
            return e;
        }

        private void findNextVal() {
            E[] array = this.buffer;
            Object e = null;
            for (int i = this.index; i < array.length; ++i) {
                e = array[i];
                if (e == null || e == TOMBSTONE) continue;
                this.nextVal = e;
                this.index = i + 1;
                return;
            }
            this.nextVal = null;
        }

        @Override
        public void remove() {
            E e = this.lastVal;
            if (e != null) {
                this.lastVal = null;
                this.set.remove(e);
            }
        }
    }
}

