/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.ClassOptimizationInfo;

public class StaticInitializerContainingClassMarker
extends SimplifiedVisitor
implements ClassVisitor {
    public void visitAnyClass(Clazz clazz) {
        if (clazz.findMethod("<clinit>", "()V") != null) {
            StaticInitializerContainingClassMarker.setStaticInitializer(clazz);
        }
    }

    private static void setStaticInitializer(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (classOptimizationInfo != null) {
            classOptimizationInfo.setContainsStaticInitializer();
        }
    }

    public static boolean containsStaticInitializer(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return classOptimizationInfo == null || classOptimizationInfo.containsStaticInitializer();
    }
}

