/*
 * Decompiled with CFR 0.152.
 */
package cocaine.message;

import cocaine.hpack.HeaderField;
import java.util.List;
import java.util.Objects;
import org.msgpack.type.Value;

public class Message {
    private final int type;
    private final long session;
    private final Value payload;
    private final List<HeaderField> headers;

    public Message(int type, long session, Value payload, List<HeaderField> headers) {
        this.type = type;
        this.session = session;
        this.payload = payload;
        this.headers = headers;
    }

    public int getType() {
        return this.type;
    }

    public long getSession() {
        return this.session;
    }

    public Value getPayload() {
        return this.payload;
    }

    public List<HeaderField> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message m = (Message)o;
        return this.session == m.session && this.type == m.type && Objects.equals(this.payload, m.getPayload());
    }

    public int hashCode() {
        int result = 31 * this.type + (int)(this.session ^ this.session >>> 32);
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public String toString() {
        return "session " + this.session + ", type " + this.type;
    }
}

